/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customerorg.local.service.helper;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.mdm.business.customerorg.local.entity.CustomerOrg;
import com.biz.crm.mdm.business.customerorg.local.repository.CustomerOrgRepository;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgCreateDto;
import com.biz.crm.mdm.business.customerorg.sdk.dto.CustomerOrgUpdateDto;
import com.biz.crm.mdm.business.customerorg.sdk.event.CustomerOrgEventListener;
import com.biz.crm.mdm.business.customerorg.sdk.vo.CustomerOrgVo;
import com.bizunited.nebula.common.util.JsonUtils;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class CustomerOrgServiceHelper {
    private static final Logger log = LoggerFactory.getLogger(CustomerOrgServiceHelper.class);
    @Autowired
    private CustomerOrgRepository customerOrgRepository;
    @Autowired(required=false)
    private List<CustomerOrgEventListener> customerOrgEventListeners;

    public void createValidation(CustomerOrgCreateDto customerOrgCreateDto) {
        Validate.notNull((Object)customerOrgCreateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u65b0\u589e\u5ba2\u6237\u7ec4\u7ec7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)customerOrgCreateDto));
        Validate.notBlank((CharSequence)customerOrgCreateDto.getCustomerOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<CustomerOrg> customerOrgs = this.customerOrgRepository.findListByName(customerOrgCreateDto.getCustomerOrgName(), false, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(customerOrgs), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)customerOrgCreateDto.getCustomerOrgCode())) {
            CustomerOrg customerOrg = this.customerOrgRepository.findDetailsByCode(customerOrgCreateDto.getCustomerOrgCode(), TenantUtils.getTenantCode());
            Validate.isTrue((null == customerOrg ? 1 : 0) != 0, (String)("\u7f16\u7801[" + customerOrgCreateDto.getCustomerOrgCode() + "]\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        if (StringUtils.isNotEmpty((CharSequence)customerOrgCreateDto.getParentCode())) {
            CustomerOrg parent = this.customerOrgRepository.findDetailsByCode(customerOrgCreateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7f16\u7801\u65e0\u6548", (Object[])new Object[0]);
        }
        Validate.notBlank((CharSequence)customerOrgCreateDto.getCustomerOrgType(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerOrgCreateDto.getEnableStatus(), (String)"\u65b0\u589e\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((customerOrgCreateDto.getCustomerOrgName().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u65b0\u589e\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void updateValidation(CustomerOrgUpdateDto customerOrgUpdateDto) {
        Validate.notNull((Object)customerOrgUpdateDto, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!", (Object[])new Object[0]);
        log.info("\u7f16\u8f91\u5ba2\u6237\u7ec4\u7ec7\u8bf7\u6c42dto\uff1a{}", (Object)JsonUtils.obj2JsonString((Object)customerOrgUpdateDto));
        Validate.notBlank((CharSequence)customerOrgUpdateDto.getId(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        CustomerOrg customerOrg = this.customerOrgRepository.findDetailsById(customerOrgUpdateDto.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)customerOrg), (String)"\u65e0\u6548\u7684\u4e1a\u52a1\u6280\u672f\u7f16\u53f7\u4fe1\u606f", (Object[])new Object[0]);
        CustomerOrg detailsByCode = this.customerOrgRepository.findDetailsByCode(customerOrgUpdateDto.getCustomerOrgCode(), TenantUtils.getTenantCode());
        Validate.isTrue((detailsByCode == null || customerOrgUpdateDto.getId().equals(detailsByCode.getId()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        List idsByName = ((List)Optional.ofNullable(this.customerOrgRepository.findListByName(customerOrgUpdateDto.getCustomerOrgName(), false, TenantUtils.getTenantCode())).orElse(new ArrayList())).stream().map(UuidEntity::getId).collect(Collectors.toList());
        Validate.isTrue((CollectionUtils.isEmpty(idsByName) || idsByName.size() == 1 && idsByName.contains(customerOrgUpdateDto.getId()) ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)customerOrg.getRuleCode(), (String)"\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)customerOrgUpdateDto.getCustomerOrgCode(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)customerOrg.getCustomerOrgCode().equals(customerOrgUpdateDto.getCustomerOrgCode()), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)customerOrgUpdateDto.getParentCode())) {
            CustomerOrg parent = this.customerOrgRepository.findDetailsByCode(customerOrgUpdateDto.getParentCode(), TenantUtils.getTenantCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Validate.isTrue((!parent.getId().equals(customerOrg.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u662f\u81ea\u5df1", (Object[])new Object[0]);
            Validate.isTrue((!parent.getRuleCode().startsWith(customerOrg.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7", (Object[])new Object[0]);
            if (!parent.getCustomerOrgCode().equals(customerOrg.getParentCode())) {
                Validate.notBlank((CharSequence)parent.getRuleCode(), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            }
        }
        Validate.notBlank((CharSequence)customerOrgUpdateDto.getCustomerOrgName(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)customerOrgUpdateDto.getCustomerOrgType(), (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5ba2\u6237\u7ec4\u7ec7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((customerOrgUpdateDto.getCustomerOrgName().length() < 128 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4fe1\u606f\uff0c\u5728\u8fdb\u884c\u4fee\u6539\u65f6\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    public void sendCreateEvent(List<CustomerOrgVo> customerOrgVos) {
        if (Objects.nonNull(this.customerOrgEventListeners)) {
            for (CustomerOrgEventListener listener : this.customerOrgEventListeners) {
                listener.onBatchCreate(customerOrgVos);
            }
        }
    }

    public void sendUpdateEvent(List<CustomerOrgVo> customerOrgVos) {
        if (Objects.nonNull(this.customerOrgEventListeners)) {
            for (CustomerOrgEventListener listener : this.customerOrgEventListeners) {
                listener.onBatchUpdate(customerOrgVos);
            }
        }
    }

    public void sendEnableEvent(List<CustomerOrgVo> customerOrgVos) {
        if (Objects.nonNull(this.customerOrgEventListeners)) {
            for (CustomerOrgEventListener listener : this.customerOrgEventListeners) {
                listener.onBatchEnable(customerOrgVos);
            }
        }
    }

    public void sendDisableEvent(List<CustomerOrgVo> customerOrgVos) {
        if (Objects.nonNull(this.customerOrgEventListeners)) {
            for (CustomerOrgEventListener listener : this.customerOrgEventListeners) {
                listener.onBatchDisable(customerOrgVos);
            }
        }
    }

    public void sendDeleteEvent(List<CustomerOrgVo> customerOrgVos) {
        if (Objects.nonNull(this.customerOrgEventListeners)) {
            for (CustomerOrgEventListener listener : this.customerOrgEventListeners) {
                listener.onBatchDelete(customerOrgVos);
            }
        }
    }
}

