package com.biz.crm.mdm.business.customeruser.local.controller;

import com.biz.crm.mdm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customeruser.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 客户用户控制层
 *
 * @author sunx
 * @since 2021-10-20 16:35:06
 */
@Slf4j
@Api(tags = "客户用户: CustomerUserVo: 客户用户")
@RestController
@RequestMapping(value = {"/v1/customeruser/customeruser"})
public class CustomerUserVoController {

  @Autowired
  private CustomerUserVoService customerUserVoService;

  @ApiOperation(value = "详情")
  @GetMapping(value = {"/findDetailById"})
  public Result<CustomerUserVo> findDetailById(@RequestParam("id") String id) {
    List<String> ids = Lists.newArrayList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    try {
      CustomerUserVo vo = null;
      List<CustomerUserVo> list = customerUserVoService.findDetailsByIdsOrUserCodes(ids, null);
      if (CollectionUtils.isNotEmpty(list)) {
        vo = list.stream().findFirst().get();
      }
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "创建")
  @PostMapping(value = "")
  public Result<CustomerUserVo> create(@RequestBody CustomerUserDto dto) {
    try {
      CustomerUserVo vo = this.customerUserVoService.create(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PatchMapping(value = "")
  public Result<CustomerUserVo> update(@RequestBody CustomerUserDto dto) {
    try {
      CustomerUserVo vo = this.customerUserVoService.update(dto);
      return Result.ok(vo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
