package com.biz.crm.mdm.business.customeruser.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.mdm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customeruser.sdk.deprecated.MdmCustomerUserPageReqVo;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customeruser.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author sunx
 * @date 2021/10/25
 */
@Slf4j
@RestController
@RequestMapping("/mdmCustomerUserController")
@Api(tags = "MDM-用户管理（客户用户）")
@Deprecated
public class MdmCustomerUserController {

  @Autowired
  private CustomerUserService customerUserService;
  @Autowired
  private CustomerUserVoService customerUserVoService;
  @Autowired
  private NebulaToolkitService nebulaToolkitService;

  @ApiOperation(value = "查询分页列表")
  @PostMapping("/pageList")
  public Result<PageResult<CustomerUser>> pageList(
      @RequestBody MdmCustomerUserPageReqVo reqVo) {
    try {
      reqVo = Optional.ofNullable(reqVo).orElse(new MdmCustomerUserPageReqVo());
      CustomerUserPaginationDto dto = nebulaToolkitService
          .copyObjectByWhiteList(reqVo, CustomerUserPaginationDto.class, HashSet.class,
              ArrayList.class);
      Page<CustomerUser> page = customerUserService
          .findByConditions(
              PageRequest.of(reqVo.getPageNum(), reqVo.getPageSize()), dto);
      PageResult<CustomerUser> pageResult = PageResult.<CustomerUser>builder()
          .data(page.getRecords())
          .count(page.getTotal())
          .build();
      return Result.ok(pageResult);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情（客户用户）", httpMethod = "GET")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = false, dataType = "String", paramType = "query"),
      @ApiImplicitParam(name = "userCode", value = "用户编码", required = false, dataType = "String", paramType = "query")
  })
  @GetMapping("/detail")
  public Result<CustomerUserVo> detail(@RequestParam(value = "id", required = false) String id,
      @RequestParam(value = "userCode", required = false) String userCode) {
    List<String> ids = Lists.newArrayList();
    if (StringUtils.isNotBlank(id)) {
      ids.add(id);
    }
    List<String> userCodes = Lists.newArrayList();
    if (StringUtils.isNotBlank(userCode)) {
      userCodes.add(userCode);
    }
    CustomerUserVo vo = null;
    List<CustomerUserVo> list = customerUserVoService.findDetailsByIdsOrUserCodes(ids, userCodes);
    if (CollectionUtils.isNotEmpty(list)) {
      vo = list.stream().findFirst().get();
    }
    return Result.ok(vo);
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result save(@RequestBody CustomerUserDto dto) {
    customerUserVoService.create(dto);
    return Result.ok();
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody CustomerUserDto dto) {
    customerUserVoService.update(dto);
    return Result.ok("修改成功");
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    customerUserService.updateDelFlagByIds(ids);
    return Result.ok("删除成功");
  }

  @ApiOperation(value = "启用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/enable")
  public Result enable(@RequestBody List<String> ids) {
    customerUserService.enableBatch(ids);
    return Result.ok("启用成功");
  }

  @ApiOperation(value = "禁用", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/disable")
  public Result disable(@RequestBody List<String> ids) {
    customerUserService.disableBatch(ids);
    return Result.ok("禁用成功");
  }

  @ApiOperation(value = "强制批量修改密码", httpMethod = "POST")
  @PostMapping("/forceChangePassword")
  public Result forceChangePassword(@RequestBody CustomerUserResetPasswordDto dto) {
    customerUserService.resetPassword(dto);
    return Result.ok("修改成功");
  }
}
