package com.biz.crm.mdm.business.customeruser.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.mdm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户用户与终端关联表(mdm_customer_user_r_terminal)
 *
 * @author sunx
 * @since 2021-10-20 16:36:37
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Entity
@TableName("mdm_customer_user_r_terminal")
@Table(name = "mdm_customer_user_r_terminal", indexes = {
    @Index(name = "mdm_customer_user_r_terminal_index1", columnList = "terminal_code"),
    @Index(name = "mdm_customer_user_r_terminal_index2", columnList = "org_code"),
    @Index(name = "mdm_customer_user_r_terminal_index3", columnList = "customer_code"),
    @Index(name = "mdm_customer_user_r_terminal_index4", columnList = "position_code"),
    @Index(name = "mdm_customer_user_r_terminal_index5", columnList = "user_code")
})
@org.hibernate.annotations.Table(appliesTo = "mdm_customer_user_r_terminal", comment = "客户用户与终端关联表")
@ApiModel(value = "CustomerUserRTerminal", description = "客户用户与终端关联表")
public class CustomerUserRTerminal extends TenantEntity {

  @ApiModelProperty("供货关系类型")
  @TableField(value = "supply_type")
  @Column(name = "supply_type", length = 64, columnDefinition = "varchar(64) COMMENT '供货关系类型'")
  private String supplyType;

  @ApiModelProperty("用户编码")
  @TableField(value = "user_code")
  @Column(name = "user_code", length = 64, columnDefinition = "varchar(64) COMMENT '用户编码'")
  private String userName;

  @ApiModelProperty("终端编码")
  @TableField(value = "terminal_code")
  @Column(name = "terminal_code", length = 64, columnDefinition = "varchar(64) COMMENT '终端编码'")
  private String terminalCode;

  @ApiModelProperty("组织编码")
  @TableField(value = "org_code")
  @Column(name = "org_code", length = 64, columnDefinition = "varchar(64) COMMENT '组织编码'")
  private String orgCode;

  @ApiModelProperty("上级客户编码")
  @TableField(value = "customer_code")
  @Column(name = "customer_code", length = 64, columnDefinition = "varchar(64) COMMENT '上级客户编码'")
  private String customerCode;

  @ApiModelProperty("上级客户编码")
  @TableField(value = "position_code")
  @Column(name = "position_code", length = 64, columnDefinition = "varchar(64) COMMENT '职位编码'")
  private String positionCode;

  @ApiModelProperty("销售公司")
  @TableField(value = "sale_company")
  @Column(name = "sale_company", length = 64, columnDefinition = "varchar(64) COMMENT '销售公司'")
  private String saleCompany;

  @ApiModelProperty("渠道")
  @TableField(value = "channel")
  @Column(name = "channel", length = 64, columnDefinition = "varchar(64) COMMENT '渠道'")
  private String channel;
}
