package com.biz.crm.mdm.business.customeruser.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRCustomer;
import com.biz.crm.mdm.business.customeruser.local.mapper.CustomerUserRCustomerMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 客户用户与客户关联客户表(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:36:38
 */
@Component
public class CustomerUserRCustomerRepository extends
    ServiceImpl<CustomerUserRCustomerMapper, CustomerUserRCustomer> {

  public List<CustomerUserRCustomer> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery().eq(CustomerUserRCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRCustomer::getUserCode, userCodeList).list();
  }

  public void deleteByUserCodes(List<String> userCodeList) {
    LambdaQueryWrapper<CustomerUserRCustomer> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(CustomerUserRCustomer::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRCustomer::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }
}
