package com.biz.crm.mdm.business.customeruser.local.repository;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRRole;
import com.biz.crm.mdm.business.customeruser.local.mapper.CustomerUserRRoleMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 客户用户关联角色(repository)
 *
 * @author sunx
 * @date 2021-11-01 09:30:12
 */
@Component
public class CustomerUserRRoleRepository extends
    ServiceImpl<CustomerUserRRoleMapper, CustomerUserRRole> {

  public List<CustomerUserRRole> findByUserCodes(List<String> userCodeList) {
    return this.lambdaQuery().eq(CustomerUserRRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRRole::getUserCode, userCodeList).list();
  }

  public void deleteByUserCodes(ArrayList<String> userCodeList) {
    LambdaQueryWrapper<CustomerUserRRole> lambdaQuery = Wrappers.lambdaQuery();
    lambdaQuery.eq(CustomerUserRRole::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUserRRole::getUserCode, userCodeList);
    baseMapper.delete(lambdaQuery);
  }

  public List<CustomerUserRRole> findByRoleCodesAndTenantCode(List<String> roleCodeList,
      String tenantCode) {
    return this.lambdaQuery().eq(CustomerUserRRole::getTenantCode, tenantCode)
        .in(CustomerUserRRole::getRoleCode, roleCodeList).list();
  }
}
