package com.biz.crm.mdm.business.customeruser.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.mdm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mdm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.mapper.CustomerUserMapper;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

/**
 * 客户用户(repository)
 *
 * @author sunx
 * @since 2021-10-20 16:35:04
 */
@Component
public class CustomerUserRepository extends ServiceImpl<CustomerUserMapper, CustomerUser> {

  /**
   * 分页
   *
   * @param page
   * @param dto
   * @return
   */
  public Page<CustomerUser> findByConditions(Page<CustomerUser> page,
      CustomerUserPaginationDto dto) {
    dto.setTenantCode(TenantUtils.getTenantCode());
    return baseMapper.findByConditions(page, dto);
  }

  public CustomerUser findById(String id) {
    return this.baseMapper.selectById(id);
  }

  /**
   * 根据id集合获取详情集合
   *
   * @param ids
   * @return
   */
  public List<CustomerUser> findByIds(List<String> ids) {
    return this.lambdaQuery().in(CustomerUser::getId, ids).list();
  }

  /**
   * 根据id集合 更新组织启用/禁用状态
   *
   * @param ids
   * @param enable
   */
  public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
    this.lambdaUpdate().in(CustomerUser::getId, ids)
        .set(CustomerUser::getEnableStatus, enable.getCode()).update();
  }

  /**
   * 逻辑删除
   *
   * @param ids
   */
  public void updateDelFlagByIds(List<String> ids) {
    this.lambdaUpdate().in(CustomerUser::getId, ids)
        .set(CustomerUser::getDelFlag, DelFlagStatusEnum.DELETE.getCode()).update();
  }

  /**
   * 根据编码获取集合
   *
   * @param userCodes
   * @return
   */
  public List<CustomerUser> findByUserCodes(List<String> userCodes) {
    return this.lambdaQuery().eq(CustomerUser::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUser::getUserCode, userCodes).list();
  }

  public Integer countByUserCode(String userCode) {
    return lambdaQuery().eq(CustomerUser::getTenantCode, TenantUtils.getTenantCode())
        .eq(CustomerUser::getUserCode, userCode).count();
  }

  /**
   * 重置密码
   *
   * @param dto
   */
  public void resetPassword(CustomerUserResetPasswordDto dto) {
    lambdaUpdate().eq(CustomerUser::getTenantCode, TenantUtils.getTenantCode())
        .in(CustomerUser::getId, dto.getIds())
        .set(CustomerUser::getUserPassword, dto.getPassword())
        .set(CustomerUser::getUpdatePasswordDate, new Date()).update();
  }

  public List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList,
      String tenantCode) {
    return this.baseMapper
        .findByRoleCodesAndTenantCode(roleCodeList, tenantCode, DelFlagStatusEnum.NORMAL.getCode());
  }
}
