package com.biz.crm.mdm.business.customeruser.local.service;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRRole;
import java.util.List;

/**
 * 客户用户关联角色(CustomerUserRRole)表服务接口
 *
 * @author sunx
 * @date 2021-11-01 09:30:13
 */
public interface CustomerUserRRoleService {

  /**
   * 根据客户用户编码获取绑定的角色集合信息
   *
   * @param userCodeList
   * @return
   */
  List<CustomerUserRRole> findByUserCodes(List<String> userCodeList);

  /**
   * 批量保存关联角色
   *
   * @param roleList
   * @param userCode
   */
  void saveBatch(List<CustomerUserRRole> roleList, String userCode);

  /**
   * 根据角色编码获取关联的用户信息
   *
   * @param roleCodeList
   * @param tenantCode
   * @return
   */
  List<CustomerUserRRole> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode);
}
