package com.biz.crm.mdm.business.customeruser.local.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Pageable;

/**
 * 客户用户(CustomerUser)表服务接口
 *
 * @author sunx
 * @since 2021-10-20 16:35:05
 */
public interface CustomerUserService {

  /**
   * 分页条件查询
   *
   * @param pageable
   * @param dto
   * @return
   */
  Page<CustomerUser> findByConditions(Pageable pageable, CustomerUserPaginationDto dto);

  /**
   * 按id查询详情
   *
   * @param id
   * @return
   */
  CustomerUser findDetailById(String id);

  /**
   * 创建
   *
   * @param customerUser
   * @return
   */
  CustomerUser create(CustomerUser customerUser);

  /**
   * 更新
   *
   * @param customerUser
   * @return
   */
  CustomerUser update(CustomerUser customerUser);

  /**
   * 按id集合启用
   *
   * @param ids
   */
  void enableBatch(List<String> ids);

  /**
   * 按id集合禁用
   *
   * @param ids
   */
  void disableBatch(List<String> ids);

  /**
   * 逻辑删除
   *
   * @param ids
   */
  void updateDelFlagByIds(List<String> ids);

  /**
   * 根据id或编码获取集合
   *
   * @param ids
   * @param userCodes
   * @return
   */
  List<CustomerUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes);

  /**
   * 重置密码
   *
   * @param dto
   */
  void resetPassword(CustomerUserResetPasswordDto dto);

  /**
   * 根据角色及租户编码获取匹配数据集合
   *
   * @param roleCodeList
   * @param tenantCode
   * @return
   */
  List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode);
}
