package com.biz.crm.mdm.business.customeruser.local.service.internal;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRCustomer;
import com.biz.crm.mdm.business.customeruser.local.repository.CustomerUserRCustomerRepository;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRCustomerService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * 客户用户与客户关联客户表服务实现类
 *
 * @author sunx
 * @since 2021-10-20 16:36:39
 */
@Slf4j
@Service("customerUserRCustomerService")
public class CustomerUserRCustomerServiceImpl implements CustomerUserRCustomerService {

  @Autowired
  private CustomerUserRCustomerRepository customerUserRCustomerRepository;

  @Override
  public List<CustomerUserRCustomer> findByUserCodes(List<String> userCodeList) {
    if (CollectionUtils.isEmpty(userCodeList)) {
      return Lists.newArrayList();
    }
    return customerUserRCustomerRepository.findByUserCodes(userCodeList);
  }

  @Override
  @Transactional
  public void saveBatch(List<CustomerUserRCustomer> list, String userCode) {
    Validate.notBlank(userCode, "客户用户编码信息不能为空");
    customerUserRCustomerRepository.deleteByUserCodes(Lists.newArrayList(userCode));
    if (CollectionUtils.isEmpty(list)) {
      return;
    }
    Optional<CustomerUserRCustomer> first = list.stream().filter(
        a -> StringUtils.isBlank(a.getUserCode())
            || StringUtils.isBlank(a.getCustomerCode())
            || !userCode.equals(a.getUserCode()))
        .findFirst();
    Validate.isTrue(!first.isPresent(), "用户编码或客户编码不能为空，且必须属于同一个客户用户");
    Map<String, List<CustomerUserRCustomer>> map = list.stream().collect(
        Collectors.groupingBy(CustomerUserRCustomer::getCustomerCode));
    map.entrySet().forEach(a -> {
      Validate.isTrue(a.getValue().size() <= 1, "存在重复的客户编码");
    });
    for (CustomerUserRCustomer item : list) {
      item.setId(null);
      item.setTenantCode(TenantUtils.getTenantCode());
    }
    customerUserRCustomerRepository.saveBatch(list);
  }
}
