package com.biz.crm.mdm.business.customeruser.local.service.notifier;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRRole;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRRoleService;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customeruser.sdk.constant.CustomerUserConstant;
import com.bizunited.nebula.rbac.sdk.event.RoleUpRelationRegister;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 角色向上关联客户用户信息
 *
 * @author sunx
 * @date 2021/11/1
 */
@Component
public class CustomerUserRoleUpRelationRegisterImpl implements RoleUpRelationRegister {

  @Autowired
  private CustomerUserService customerUserService;

  @Override
  public String moduleName() {
    return CustomerUserConstant.CUSTOMER_USER_MODULE_NAME;
  }

  /**
   * 当角色发生第三方业务模块关联数据查询时。 返回和这个roleCode绑定的客户用户账号集合
   */
  @Override
  public List<String> onRequestUserAccount(String roleCode, String tenantCode) {
    if (StringUtils.isAnyBlank(roleCode, tenantCode)) {
      return Lists.newArrayList();
    }
    List<CustomerUser> entities = this.customerUserService
        .findByRoleCodesAndTenantCode(Lists.newArrayList(roleCode), tenantCode);
    if (CollectionUtils.isEmpty(entities)) {
      return Lists.newArrayList();
    }
    return entities.stream().map(CustomerUser::getUserName).collect(Collectors.toList());
  }
}
