/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.deprecated.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.deprecated.model.PageResult;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customeruser.sdk.deprecated.MdmCustomerUserPageReqVo;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customeruser.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmCustomerUserController"})
@Api(tags={"MDM-\u7528\u6237\u7ba1\u7406\uff08\u5ba2\u6237\u7528\u6237\uff09"})
@Deprecated
public class MdmCustomerUserController {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerUserController.class);
    @Autowired
    private CustomerUserService customerUserService;
    @Autowired
    private CustomerUserVoService customerUserVoService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    @ApiOperation(value="\u67e5\u8be2\u5206\u9875\u5217\u8868")
    @PostMapping(value={"/pageList"})
    public Result<PageResult<CustomerUser>> pageList(@RequestBody MdmCustomerUserPageReqVo reqVo) {
        try {
            reqVo = Optional.ofNullable(reqVo).orElse(new MdmCustomerUserPageReqVo());
            CustomerUserPaginationDto dto = (CustomerUserPaginationDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)reqVo, CustomerUserPaginationDto.class, HashSet.class, ArrayList.class, new String[0]);
            Page<CustomerUser> page = this.customerUserService.findByConditions((Pageable)PageRequest.of((int)reqVo.getPageNum(), (int)reqVo.getPageSize()), dto);
            PageResult pageResult = PageResult.builder().data(page.getRecords()).count(Long.valueOf(page.getTotal())).build();
            return Result.ok((Object)pageResult);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5\uff08\u5ba2\u6237\u7528\u6237\uff09", httpMethod="GET")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="ID", required=false, dataType="String", paramType="query"), @ApiImplicitParam(name="userCode", value="\u7528\u6237\u7f16\u7801", required=false, dataType="String", paramType="query")})
    @GetMapping(value={"/detail"})
    public Result<CustomerUserVo> detail(@RequestParam(value="id", required=false) String id, @RequestParam(value="userCode", required=false) String userCode) {
        ArrayList ids = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            ids.add(id);
        }
        ArrayList userCodes = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)userCode)) {
            userCodes.add(userCode);
        }
        CustomerUserVo vo = null;
        List list = this.customerUserVoService.findDetailsByIdsOrUserCodes((List)ids, (List)userCodes);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vo = (CustomerUserVo)list.stream().findFirst().get();
        }
        return Result.ok(vo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody CustomerUserDto dto) {
        this.customerUserVoService.create(dto);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody CustomerUserDto dto) {
        this.customerUserVoService.update(dto);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody List<String> ids) {
        this.customerUserService.updateDelFlagByIds(ids);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody List<String> ids) {
        this.customerUserService.enableBatch(ids);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="POST")
    @ApiImplicitParams(value={@ApiImplicitParam(name="ids", value="id\u96c6\u5408", required=true, paramType="body")})
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody List<String> ids) {
        this.customerUserService.disableBatch(ids);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u5f3a\u5236\u6279\u91cf\u4fee\u6539\u5bc6\u7801", httpMethod="POST")
    @PostMapping(value={"/forceChangePassword"})
    public Result forceChangePassword(@RequestBody CustomerUserResetPasswordDto dto) {
        this.customerUserService.resetPassword(dto);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }
}

