/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.repository;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.mapper.CustomerUserMapper;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class CustomerUserRepository
extends ServiceImpl<CustomerUserMapper, CustomerUser> {
    public Page<CustomerUser> findByConditions(Page<CustomerUser> page, CustomerUserPaginationDto dto) {
        dto.setTenantCode(TenantUtils.getTenantCode());
        return ((CustomerUserMapper)this.baseMapper).findByConditions(page, dto);
    }

    public CustomerUser findById(String id) {
        return (CustomerUser)((Object)((CustomerUserMapper)this.baseMapper).selectById((Serializable)((Object)id)));
    }

    public List<CustomerUser> findByIds(List<String> ids) {
        return ((LambdaQueryChainWrapper)this.lambdaQuery().in(UuidEntity::getId, ids)).list();
    }

    public void updateEnableStatusByIds(List<String> ids, EnableStatusEnum enable) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).update();
    }

    public void updateDelFlagByIds(List<String> ids) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(UuidEntity::getId, ids)).set(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.DELETE.getCode())).update();
    }

    public List<CustomerUser> findByUserCodes(List<String> userCodes) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(CustomerUser::getUserCode, userCodes)).list();
    }

    public Integer countByUserCode(String userCode) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).eq(CustomerUser::getUserCode, (Object)userCode)).count();
    }

    public void resetPassword(CustomerUserResetPasswordDto dto) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode())).in(UuidEntity::getId, (Collection)dto.getIds())).set(CustomerUser::getUserPassword, (Object)dto.getPassword())).set(CustomerUser::getUpdatePasswordDate, (Object)new Date())).update();
    }

    public List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        return ((CustomerUserMapper)this.baseMapper).findByRoleCodesAndTenantCode(roleCodeList, tenantCode, DelFlagStatusEnum.NORMAL.getCode());
    }
}

