/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.service.internal;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRCustomer;
import com.biz.crm.mdm.business.customeruser.local.repository.CustomerUserRCustomerRepository;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRCustomerService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerUserRCustomerService")
public class CustomerUserRCustomerServiceImpl
implements CustomerUserRCustomerService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUserRCustomerServiceImpl.class);
    @Autowired
    private CustomerUserRCustomerRepository customerUserRCustomerRepository;

    @Override
    public List<CustomerUserRCustomer> findByUserCodes(List<String> userCodeList) {
        if (CollectionUtils.isEmpty(userCodeList)) {
            return Lists.newArrayList();
        }
        return this.customerUserRCustomerRepository.findByUserCodes(userCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<CustomerUserRCustomer> list, String userCode) {
        Validate.notBlank((CharSequence)userCode, (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRCustomerRepository.deleteByUserCodes(Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        Optional<CustomerUserRCustomer> first = list.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getUserCode()) || StringUtils.isBlank((CharSequence)a.getCustomerCode()) || !userCode.equals(a.getUserCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u7528\u6237\u7f16\u7801\u6216\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5ba2\u6237\u7528\u6237", (Object[])new Object[0]);
        Map<String, List<CustomerUserRCustomer>> map = list.stream().collect(Collectors.groupingBy(CustomerUserRCustomer::getCustomerCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u5ba2\u6237\u7f16\u7801", (Object[])new Object[0]));
        for (CustomerUserRCustomer item : list) {
            item.setId(null);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.customerUserRCustomerRepository.saveBatch(list);
    }

    @Override
    public Integer countByCustomerCodes(List<String> customerCodeList) {
        if (CollectionUtils.isEmpty(customerCodeList)) {
            return 0;
        }
        return this.customerUserRCustomerRepository.countByCustomerCodes(customerCodeList);
    }
}

