/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.service.internal;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRRole;
import com.biz.crm.mdm.business.customeruser.local.repository.CustomerUserRRoleRepository;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRRoleService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerUserRRoleService")
public class CustomerUserRRoleServiceImpl
implements CustomerUserRRoleService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUserRRoleServiceImpl.class);
    @Autowired
    private CustomerUserRRoleRepository customerUserRRoleRepository;

    @Override
    public List<CustomerUserRRole> findByUserCodes(List<String> userCodeList) {
        if (CollectionUtils.isEmpty(userCodeList)) {
            return Lists.newArrayList();
        }
        return this.customerUserRRoleRepository.findByUserCodes(userCodeList);
    }

    @Override
    @Transactional
    public void saveBatch(List<CustomerUserRRole> roleList, String userCode) {
        Validate.notBlank((CharSequence)userCode, (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRRoleRepository.deleteByUserCodes(Lists.newArrayList((Object[])new String[]{userCode}));
        if (CollectionUtils.isEmpty(roleList)) {
            return;
        }
        Optional<CustomerUserRRole> first = roleList.stream().filter(a -> StringUtils.isBlank((CharSequence)a.getUserCode()) || StringUtils.isBlank((CharSequence)a.getRoleCode()) || !userCode.equals(a.getUserCode())).findFirst();
        Validate.isTrue((!first.isPresent() ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7528\u6237\u7f16\u7801\u6216\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a,\u4e14\u5fc5\u987b\u5c5e\u4e8e\u540c\u4e00\u4e2a\u5ba2\u6237\u7528\u6237", (Object[])new Object[0]);
        Map<String, List<CustomerUserRRole>> map = roleList.stream().collect(Collectors.groupingBy(CustomerUserRRole::getRoleCode));
        map.entrySet().forEach(a -> Validate.isTrue((((List)a.getValue()).size() <= 1 ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\u7684\u89d2\u8272\u7f16\u7801", (Object[])new Object[0]));
        for (CustomerUserRRole item : roleList) {
            item.setId(null);
            item.setTenantCode(TenantUtils.getTenantCode());
        }
        this.customerUserRRoleRepository.saveBatch(roleList);
    }

    @Override
    public List<CustomerUserRRole> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodeList) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.customerUserRRoleRepository.findByRoleCodesAndTenantCode(roleCodeList, tenantCode);
    }
}

