/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.repository.CustomerUserRepository;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserPaginationDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserResetPasswordDto;
import com.biz.crm.mdm.business.customeruser.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="customerUserService")
public class CustomerUserServiceImpl
implements CustomerUserService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUserServiceImpl.class);
    @Autowired
    private CustomerUserRepository customerUserRepository;
    @Autowired(required=false)
    private List<CustomerUserEventListener> eventListeners;
    @Autowired(required=false)
    private GenerateCodeService generateCodeService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;

    @Override
    public Page<CustomerUser> findByConditions(Pageable pageable, CustomerUserPaginationDto dto) {
        pageable = Optional.ofNullable(pageable).orElse((Pageable)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new CustomerUserPaginationDto());
        dto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return this.customerUserRepository.findByConditions((Page<CustomerUser>)page, dto);
    }

    @Override
    public CustomerUser findDetailById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.customerUserRepository.findById(id);
    }

    @Override
    @Transactional
    public CustomerUser create(CustomerUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        if (StringUtils.isEmpty((CharSequence)terminalUser.getUserCode())) {
            terminalUser.setUserCode((String)this.generateCodeService.generateCode("KHYH", 1).get(0));
        } else {
            Integer count = this.customerUserRepository.countByUserCode(terminalUser.getUserCode());
            Validate.isTrue((null == count || 1 > count ? 1 : 0) != 0, (String)(terminalUser.getUserCode() + "\u7f16\u7801\u5df2\u5b58\u5728"), (Object[])new Object[0]);
        }
        terminalUser.setTenantCode(TenantUtils.getTenantCode());
        terminalUser.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        terminalUser.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.customerUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public CustomerUser update(CustomerUser terminalUser) {
        Validate.notNull((Object)((Object)terminalUser), (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)terminalUser.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        String currentId = terminalUser.getId();
        CustomerUser current = this.customerUserRepository.findById(currentId);
        current = (CustomerUser)((Object)Validate.notNull((Object)((Object)current), (String)"\u4fee\u6539\u4fe1\u606f\u4e0d\u5b58\u5728", (Object[])new Object[0]));
        Validate.isTrue((boolean)terminalUser.getUserCode().equals(current.getUserCode()), (String)"\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        this.customerUserRepository.saveOrUpdate((Object)terminalUser);
        return terminalUser;
    }

    @Override
    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.ENABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateEnableStatusByIds(ids, EnableStatusEnum.DISABLE);
        this.onEnableOrDisable(ids, EnableStatusEnum.ENABLE);
    }

    @Override
    @Transactional
    public void updateDelFlagByIds(List<String> ids) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(ids), (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.updateDelFlagByIds(ids);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<CustomerUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (CustomerUserEventListener eventListener : this.eventListeners) {
            eventListener.onDelete(voList);
        }
    }

    @Override
    public List<CustomerUser> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return Lists.newArrayList();
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            return this.customerUserRepository.findByIds(ids);
        }
        return this.customerUserRepository.findByUserCodes(userCodes);
    }

    @Override
    @Transactional
    public void resetPassword(CustomerUserResetPasswordDto dto) {
        Validate.notNull((Object)dto, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)dto.getIds()), (String)"\u5ba2\u6237\u7528\u6237id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        this.customerUserRepository.resetPassword(dto);
    }

    @Override
    public List<CustomerUser> findByRoleCodesAndTenantCode(List<String> roleCodeList, String tenantCode) {
        if (CollectionUtils.isEmpty(roleCodeList) || StringUtils.isBlank((CharSequence)tenantCode)) {
            return Lists.newArrayList();
        }
        return this.customerUserRepository.findByRoleCodesAndTenantCode(roleCodeList, tenantCode);
    }

    private void onEnableOrDisable(List<String> ids, EnableStatusEnum enableStatusEnum) {
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return;
        }
        List<CustomerUserVo> voList = this.findVoListByIds(ids);
        if (CollectionUtils.isEmpty(voList)) {
            return;
        }
        for (CustomerUserEventListener event : this.eventListeners) {
            if (enableStatusEnum.equals((Object)EnableStatusEnum.ENABLE)) {
                event.onEnable(voList);
                continue;
            }
            if (!enableStatusEnum.equals((Object)EnableStatusEnum.DISABLE)) continue;
            event.onDisable(voList);
        }
    }

    private List<CustomerUserVo> findVoListByIds(List<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return Lists.newArrayList();
        }
        List<CustomerUser> list = this.findDetailsByIdsOrUserCodes(ids, null);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, CustomerUser.class, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
    }
}

