/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.service.internal;

import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUser;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRCustomer;
import com.biz.crm.mdm.business.customeruser.local.entity.CustomerUserRRole;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRCustomerService;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRRoleService;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserService;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserRCustomerDto;
import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserRRoleDto;
import com.biz.crm.mdm.business.customeruser.sdk.event.CustomerUserEventListener;
import com.biz.crm.mdm.business.customeruser.sdk.service.CustomerUserVoService;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserRCustomerVo;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserRRoleVo;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CustomerUserVoServiceImpl
implements CustomerUserVoService {
    private static final Logger log = LoggerFactory.getLogger(CustomerUserVoServiceImpl.class);
    @Autowired
    private CustomerUserService customerUserService;
    @Autowired
    private CustomerUserRCustomerService customerUserRCustomerService;
    @Autowired
    private CustomerUserRRoleService customerUserRRoleService;
    @Autowired
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private List<CustomerUserEventListener> eventListeners;

    public List<CustomerUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes) {
        List<Object> re = Lists.newArrayList();
        if (CollectionUtils.isEmpty(ids) && CollectionUtils.isEmpty(userCodes)) {
            return re;
        }
        List<CustomerUser> customerUserList = this.customerUserService.findDetailsByIdsOrUserCodes(ids, userCodes);
        if (CollectionUtils.isEmpty(customerUserList)) {
            return re;
        }
        List<String> userCodeList = customerUserList.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getUserCode())).map(CustomerUser::getUserCode).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(userCodeList)) {
            return re;
        }
        List<CustomerUserRCustomer> customerList = this.customerUserRCustomerService.findByUserCodes(userCodeList);
        List<CustomerUserRRole> roleList = this.customerUserRRoleService.findByUserCodes(userCodeList);
        re = this.buildCustomerUserVoList(customerUserList, customerList, roleList);
        return re;
    }

    @Transactional
    public CustomerUserVo create(CustomerUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        CustomerUser customerUser = (CustomerUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.customerUserService.create(customerUser);
        dto.setUserCode(customerUser.getUserCode());
        this.bindExtInfo(dto);
        CustomerUserVo re = this.buildByDtoAndCustomerUser(dto, customerUser);
        if (CollectionUtils.isEmpty(this.eventListeners)) {
            return re;
        }
        for (CustomerUserEventListener eventListener : this.eventListeners) {
            eventListener.onCreate(re);
        }
        return re;
    }

    @Transactional
    public CustomerUserVo update(CustomerUserDto dto) {
        List<CustomerUserVo> list;
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        Boolean flag = CollectionUtils.isNotEmpty(this.eventListeners);
        CustomerUserVo oldVo = null;
        if (flag.booleanValue() && CollectionUtils.isNotEmpty(list = this.findDetailsByIdsOrUserCodes(Lists.newArrayList((Object[])new String[]{dto.getId()}), null))) {
            oldVo = list.get(0);
        }
        CustomerUser customerUser = (CustomerUser)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, CustomerUser.class, HashSet.class, ArrayList.class, new String[0]));
        this.customerUserService.update(customerUser);
        dto.setUserCode(customerUser.getUserCode());
        this.bindExtInfo(dto);
        CustomerUserVo re = this.buildByDtoAndCustomerUser(dto, customerUser);
        if (!flag.booleanValue()) {
            return re;
        }
        for (CustomerUserEventListener eventListener : this.eventListeners) {
            eventListener.onUpdate(oldVo, re);
        }
        return re;
    }

    @Transactional
    public void bindExtInfo(CustomerUserDto dto) {
        Validate.notNull((Object)dto, (String)"\u5ba2\u6237\u7528\u6237\u4fe1\u606f\u7f3a\u5931", (Object[])new Object[0]);
        List customerList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
            customerList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerList(), CustomerUserRCustomerDto.class, CustomerUserRCustomer.class, HashSet.class, ArrayList.class, new String[0]);
            customerList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.customerUserRCustomerService.saveBatch(customerList, dto.getUserCode());
        List roleList = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)dto.getRoleList())) {
            roleList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getRoleList(), CustomerUserRRoleDto.class, CustomerUserRRole.class, HashSet.class, ArrayList.class, new String[0]);
            roleList.forEach(a -> a.setUserCode(dto.getUserCode()));
        }
        this.customerUserRRoleService.saveBatch(roleList, dto.getUserCode());
    }

    private List<CustomerUserVo> buildCustomerUserVoList(List<CustomerUser> customerUserList, List<CustomerUserRCustomer> customerList, List<CustomerUserRRole> roleList) {
        List voList;
        List<CustomerUserVo> re = Lists.newArrayList();
        Map<Object, Object> mapCustomer = Maps.newHashMap();
        Map<Object, Object> mapRole = Maps.newHashMap();
        if (CollectionUtils.isEmpty(customerUserList)) {
            return re;
        }
        re = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerUserList, CustomerUser.class, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty(customerList)) {
            voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(customerList, CustomerUserRCustomer.class, CustomerUserRCustomerVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapCustomer = voList.stream().collect(Collectors.groupingBy(CustomerUserRCustomerVo::getUserCode));
        }
        if (CollectionUtils.isNotEmpty(roleList)) {
            voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(roleList, CustomerUserRRole.class, CustomerUserRRoleVo.class, HashSet.class, ArrayList.class, new String[0]);
            mapRole = voList.stream().collect(Collectors.groupingBy(CustomerUserRRoleVo::getUserCode));
        }
        for (CustomerUserVo item : re) {
            item.setCustomerList((List)mapCustomer.get(item.getUserCode()));
            item.setRoleList((List)mapRole.get(item.getUserCode()));
        }
        return re;
    }

    private CustomerUserVo buildByDtoAndCustomerUser(CustomerUserDto dto, CustomerUser customerUser) {
        if (Objects.isNull((Object)customerUser) || Objects.isNull(dto)) {
            return null;
        }
        CustomerUserVo vo = (CustomerUserVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)customerUser, CustomerUserVo.class, HashSet.class, ArrayList.class, new String[0]);
        if (CollectionUtils.isNotEmpty((Collection)dto.getCustomerList())) {
            vo.setCustomerList((List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)dto.getCustomerList(), CustomerUserRCustomerDto.class, CustomerUserRCustomerVo.class, HashSet.class, ArrayList.class, new String[0]));
        }
        return vo;
    }
}

