/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.customeruser.local.service.notifier;

import com.biz.crm.mdm.business.customer.sdk.event.CustomerEventListener;
import com.biz.crm.mdm.business.customer.sdk.vo.CustomerEventVo;
import com.biz.crm.mdm.business.customeruser.local.service.CustomerUserRCustomerService;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomerEventListenerImpl
implements CustomerEventListener {
    @Autowired
    private CustomerUserRCustomerService customerUserRCustomerService;

    public void onCreate(CustomerEventVo vo) {
    }

    public void onUpdate(CustomerEventVo oldVo, CustomerEventVo newVo) {
    }

    public void onDisable(List<CustomerEventVo> voList) {
    }

    public void onEnable(List<CustomerEventVo> voList) {
    }

    public void onDelete(List<CustomerEventVo> list) {
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(list), (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<String> customerCodeList = list.stream().filter(a -> StringUtils.isNotBlank((CharSequence)a.getCustomerCode())).map(CustomerEventVo::getCustomerCode).collect(Collectors.toList());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(customerCodeList), (String)"\u5ba2\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Integer count = this.customerUserRCustomerService.countByCustomerCodes(customerCodeList);
        Validate.isTrue((count < 1 ? 1 : 0) != 0, (String)"\u5bf9\u5e94\u7684\u5ba2\u6237\u5df2\u5b58\u5728\u5173\u8054\u7684\u5ba2\u6237\u7528\u6237\u4fe1\u606f\uff0c\u4e0d\u80fd\u6267\u884c\u5220\u9664", (Object[])new Object[0]);
    }

    public void onFreeze(List<CustomerEventVo> voList) {
    }

    public void onUnfreeze(List<CustomerEventVo> voList) {
    }
}

