package com.biz.crm.mdm.business.customeruser.sdk.dto;

import com.biz.crm.mdm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 客户用户分页查询dto
 *
 * @author sunx
 * @since 2021-10-20 16:37:34
 */
@Data
@ApiModel(value = "CustomerUserPaginationDto", description = "客户用户分页查询dto")
public class CustomerUserPaginationDto extends TenantFlagOpDto {

  /**
   * 用户账号登录信息
   */
  @ApiModelProperty("用户账号登录信息")
  private String userName;

  /**
   * 人员姓名
   */
  @ApiModelProperty("人员姓名")
  private String fullName;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;
}

