package com.biz.crm.mdm.business.customeruser.sdk.event;

import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import java.util.List;

/**
 * 客户用户变更事件通知接口
 *
 * @author sunx
 * @since 2021-10-20 16:37:36
 */
public interface CustomerUserEventListener {

  /**
   * 创建时触发
   *
   * @param vo
   */
  default void onCreate(CustomerUserVo vo) {
  }

  /**
   * 编辑时触发
   *
   * @param oldVo
   * @param newVo
   */
  default void onUpdate(CustomerUserVo oldVo, CustomerUserVo newVo) {
  }

  /**
   * 启用时触发
   *
   * @param list
   */
  default void onEnable(List<CustomerUserVo> list) {
  }

  /**
   * 禁用时触发
   *
   * @param list
   */
  default void onDisable(List<CustomerUserVo> list) {
  }

  /**
   * 删除时触发
   *
   * @param list
   */
  default void onDelete(List<CustomerUserVo> list) {
  }
}

