package com.biz.crm.mdm.business.customeruser.sdk.service;


import com.biz.crm.mdm.business.customeruser.sdk.dto.CustomerUserDto;
import com.biz.crm.mdm.business.customeruser.sdk.vo.CustomerUserVo;
import java.util.List;

/**
 * 客户用户Vo接口
 *
 * @author sunx
 * @since 2021-10-20 16:37:36
 */
public interface CustomerUserVoService {

  /**
   * 根据id或编码获取集合
   *
   * @param ids
   * @param userCodes
   * @return
   */
  List<CustomerUserVo> findDetailsByIdsOrUserCodes(List<String> ids, List<String> userCodes);

  /**
   * 新增
   *
   * @param dto
   * @return
   */
  CustomerUserVo create(CustomerUserDto dto);

  /**
   * 编辑
   *
   * @param dto
   * @return
   */
  CustomerUserVo update(CustomerUserDto dto);
}
