package com.biz.crm.mdm.business.customeruser.sdk.vo;

import com.biz.crm.mdm.business.common.sdk.vo.TenantVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 客户用户与客户关联客户表vo
 *
 * @author sunx
 * @since 2021-10-20 16:38:15
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "客户用户与客户关联客户表Vo")
public class CustomerUserRCustomerVo extends TenantVo {

  /**
   * 是否是主客户标记
   */
  @ApiModelProperty("是否是主客户标记")
  private Boolean primaryFlag;

  /**
   * 用户编码
   */
  @ApiModelProperty("用户编码")
  private String userCode;

  /**
   * 客户编码
   */
  @ApiModelProperty("客户编码")
  private String customerCode;

  /**
   * 客户名称
   */
  @ApiModelProperty("客户名称")
  private String customerName;

  /**
   * 是否是当前客户标记
   */
  @ApiModelProperty("是否是当前客户标记")
  private Boolean currentFlag;
}

