package com.biz.crm.mdm.business.dictionary.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 数据字典feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Slf4j
@Component
public class DictDataVoFeignFallbackImpl implements FallbackFactory<DictDataVoFeign> {
  @Override
  public DictDataVoFeign create(Throwable throwable) {
    return new DictDataVoFeign() {
      @Override
      public Result<Map<String, List<DictDataVo>>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
        throw new UnsupportedOperationException("根据数据字典类型编码集合获取数据字典信息熔断");
      }

      @Override
      public Result<List<DictDataVo>> findByDictTypeCode(String dictTypeCode) {
        throw new UnsupportedOperationException("根据dictTypeCode获取字段数据列表熔断");
      }
    };
  }
}
