package com.biz.crm.mdm.business.dictionary.feign.feign;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.internal.DictDataVoFeignFallbackImpl;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 数据字典feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
        name = "${feign.urlip:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = DictDataVoFeignFallbackImpl.class)
public interface DictDataVoFeign {

    /**
     * 根据数据字典类型编码集合获取数据字典信息
     *
     * @param dictTypeCodeList 数据字典类型编码集合
     * @return 数据字典信息
     */
    @GetMapping("/v1/dictionary/dictdata/findByDictTypeCodeList")
    Result<Map<String, List<DictDataVo>>> findByDictTypeCodeList(@RequestParam(value = "dictTypeCodeList") List<String> dictTypeCodeList);

    /**
     * 根据dictTypeCode获取字段数据列表
     *
     * @param dictTypeCode dict类型代码
     * @return {@link Result}<{@link List}<{@link DictDataVo}>>
     */
    @GetMapping("/v1/dictionary/dictdata/findByDictTypeCode")
    Result<List<DictDataVo>> findByDictTypeCode(@RequestParam(value = "dictTypeCode") String dictTypeCode);

    /**
     * 包含扩展字段的数据字典下拉
     *
     * @param dictTypeCode   dict类型代码
     * @param parentDictCode 上次字典编码
     * @param dictValue      字典值
     * @return {@link Result}<{@link List}<{@link JSONObject}>>
     */
    @GetMapping("/v1/dictionary/dictdata/findContainExtendByConditions")
    Result<List<JSONObject>> findContainExtendByConditions(@RequestParam(value = "dictTypeCode") String dictTypeCode,
                                                           @RequestParam(value = "parentDictCode", required = false) String parentDictCode,
                                                           @RequestParam(value = "dictValue", required = false) String dictValue);

    /**
     * 根据ID查询详情
     *
     * @param id dict类型代码
     * @return {@link Result}<{@link DictDataVo}>
     */
    @GetMapping("/v1/dictionary/dictdata/findById")
    Result<DictDataVo> findById(@RequestParam(value = "id") String id);

    /**
     * 根据字典类型和字典编码查询详情
     *
     * @param dictTypeCode 字典类型编码
     * @param dictCode     字典编码
     * @return com.biz.crm.business.common.sdk.model.Result<com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo>
     * @describe: 简述
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.10.28 22:24
     */
    @GetMapping("/v1/dictionary/dictdata/findByDictTypeCodeAndDictCode")
    Result<DictDataVo> findByDictTypeCodeAndDictCode(@RequestParam(value = "dictTypeCode") String dictTypeCode, @RequestParam(value = "dictCode") String dictCode);

    /**
     * 获取字典下级列表
     *
     * @param dictTypeCode 字典类型编码
     * @param parentDictCode 上级字典值
     * @return Result<List<DictDataVo>>
     */
    @GetMapping("/v1/dictionary/dictdata/findDictLowerByDictTypeCode")
    Result<List<DictDataVo>> findDictLowerByDictTypeCode(@RequestParam(value = "dictTypeCode", required = true) String dictTypeCode,
                                                                @RequestParam(value = "parentDictCode", required = true) String parentDictCode);

}
