package com.biz.crm.mdm.business.dictionary.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.internal.DictToolKitFeignFallbackImpl;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月09日 17:43
 */
@FeignClient(
        name = "${feign.urlip:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = DictToolKitFeignFallbackImpl.class)
public interface DictToolKitFeign {

    /**
     * 根据字典类型编码获取字典数据
     *
     * @param dictTypeCode 字典类型编码
     * @return List
     */
    @GetMapping("/v1/dictionary/toolkit/tree")
    Result<List<DictDataVo>> tree(@RequestParam(value = "dictTypeCode") String dictTypeCode);

    /**
     * 根据字典类型编码获取字典数据
     *
     * @param dictTypeCode 字典类型编码
     * @return Map
     */
    @GetMapping("/v1/dictionary/toolkit/findMapByDictTypeCode")
    Result<Map<String, String>> findMapByDictTypeCode(@RequestParam(value = "dictTypeCode") String dictTypeCode);

    /**
     * 根据字典类型编码获取字典数据
     *
     * @param dictTypeCode 字典类型编码
     * @return Map
     */
    @GetMapping("/v1/dictionary/toolkit/findConvertMapByDictTypeCode")
    Result<Map<String, String>> findConvertMapByDictTypeCode(@RequestParam(value = "dictTypeCode") String dictTypeCode);
}
