package com.biz.crm.mdm.business.dictionary.feign.feign;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.internal.DictTypeVoFeignFallbackImpl;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.SpringQueryMap;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 数据字典类型feign接口
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.29 18:57
 */
@FeignClient(
        name = "${feign.urlip:crm-mdm}",
        path = "crm-mdm",
        fallbackFactory = DictTypeVoFeignFallbackImpl.class)
public interface DictTypeVoFeign {

    /**
     * 分页获取数据字典类型列表
     *
     * @param page
     * @param size
     * @param dto
     * @return 数据字典信息
     */
    @GetMapping("/v1/dictionary/dicttype/findByConditions")
    Result<Page<DictTypeVo>> findByConditions(@RequestParam("page") Integer page,
                                              @RequestParam("size") Integer size,
                                              @SpringQueryMap DictTypeDto dto);


    /**
     * 分页获取数据字典类型列表 包含详细信息
     *
     * @param page
     * @param size
     * @param dto
     * @return 数据字典信息
     */
    @GetMapping("/v1/dictionary/dicttype/listDictTypeContainDataPage")
    Result<Page<DictTypeContainDataVo>> listDictTypeContainDataPage(@RequestParam("page") Integer page,
                                                                    @RequestParam("size") Integer size,
                                                                    @SpringQueryMap DictTypeContainDataDto dto);


    /**
     * 根据dictTypeCode获取数据字典详请
     *
     * @param dictTypeCode dict类型代码
     * @return {@link Result}<{@link DictTypeVo}>
     */
    @GetMapping("/v1/dictionary/dicttype/findByDictTypeCode")
    Result<DictTypeVo> findByDictTypeCode(@RequestParam(value = "dictTypeCode") String dictTypeCode);

    /**
     * 根据ID获取数据字典详请
     *
     * @param id dict类型代码
     * @return {@link Result}<{@link DictTypeVo}>
     */
    @GetMapping("/v1/dictionary/dicttype/findById")
    Result<DictTypeVo> findById(@RequestParam(value = "id") String id);

}
