package com.biz.crm.mdm.business.dictionary.feign.feign.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 数据字典feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Slf4j
@Component
public class DictDataVoFeignFallbackImpl implements FallbackFactory<DictDataVoFeign> {
    @Override
    public DictDataVoFeign create(Throwable throwable) {
        return new DictDataVoFeign() {
            @Override
            public Result<Map<String, List<DictDataVo>>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
                throw new UnsupportedOperationException("根据数据字典类型编码集合获取数据字典信息熔断");
            }

            @Override
            public Result<List<DictDataVo>> findByDictTypeCode(String dictTypeCode) {
                throw new UnsupportedOperationException("根据dictTypeCode获取字段数据列表熔断");
            }

            @Override
            public Result<List<JSONObject>> findContainExtendByConditions(String dictTypeCode, String parentDictCode, String dictValue) {
                throw new UnsupportedOperationException("根据dictTypeCode获取数据字典(包含扩展字段)下拉熔断");
            }

            @Override
            public Result<DictDataVo> findById(String id) {
                throw new UnsupportedOperationException("根据id获取数据字典详情熔断");
            }

            @Override
            public Result<DictDataVo> findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode) {
                throw new UnsupportedOperationException("根据字典类型和字典编码查询详情熔断");
            }

            @Override
            public Result<List<DictDataVo>> findDictLowerByDictTypeCode(String dictTypeCode, String parentDictCode) {
                throw new UnsupportedOperationException("获取字典下级列表熔断");
            }
        };
    }
}
