package com.biz.crm.mdm.business.dictionary.feign.feign.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictToolKitFeign;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

/**
 * 数据字典feign接口熔断类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Slf4j
@Component
public class DictToolKitFeignFallbackImpl implements FallbackFactory<DictToolKitFeign> {

    @Override
    public DictToolKitFeign create(Throwable cause) {
        return new DictToolKitFeign() {
            @Override
            public Result<List<DictDataVo>> tree(String dictTypeCode) {
                throw new UnsupportedOperationException("根据数据字典类型编码集合获取数据字典信息熔断");
            }

            @Override
            public Result<Map<String, String>> findMapByDictTypeCode(String dictTypeCode) {
                throw new UnsupportedOperationException("根据dictTypeCode获取Map熔断");
            }

            @Override
            public Result<Map<String, String>> findConvertMapByDictTypeCode(String dictTypeCode) {
                throw new UnsupportedOperationException("根据dictTypeCode获取Map熔断");
            }
        };
    }
}
