package com.biz.crm.mdm.business.dictionary.feign.feign.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictTypeVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

/**
 * 数据字典类型feign接口熔断类
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.29 18:56
 */
@Slf4j
@Component
public class DictTypeVoFeignFallbackImpl implements FallbackFactory<DictTypeVoFeign> {
    @Override
    public DictTypeVoFeign create(Throwable throwable) {
        return new DictTypeVoFeign() {
            @Override
            public Result<Page<DictTypeVo>> findByConditions(Integer page, Integer size, DictTypeDto dto) {
                throw new UnsupportedOperationException("根据分页信息获取数据字典类型列表熔断");
            }

            @Override
            public Result<Page<DictTypeContainDataVo>> listDictTypeContainDataPage(Integer page, Integer size, DictTypeContainDataDto dto) {
                throw new UnsupportedOperationException("根据分页信息获取数据字典类型列表熔断");
            }

            @Override
            public Result<DictTypeVo> findByDictTypeCode(String dictTypeCode) {
                throw new UnsupportedOperationException("根据dictTypeCode获取数据字典类型熔断");
            }

            @Override
            public Result<DictTypeVo> findById(String id) {
                throw new UnsupportedOperationException("根据id获取数据字典类型熔断");
            }
        };
    }
}
