package com.biz.crm.mdm.business.dictionary.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * 数据字典明细表接口实现类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@Service("FeignDictDataVoServiceImpl")
public class DictDataVoServiceImpl implements DictDataVoService {

    @Autowired(required = false)
    private DictDataVoFeign dictDataVoFeign;

    @Override
    public List<DictDataVo> findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isEmpty(dictTypeCode)){
            return Collections.emptyList();
        }
        return this.dictDataVoFeign.findByDictTypeCode(dictTypeCode).getResult();
    }

    /**
     * 获取字典下级列表
     *
     * @param dictTypeCode 字典类型编码
     * @param parentDictCode 上级字典值
     * @return List<DictDataVo>
     */
    @Override
    public List<DictDataVo> findDictLowerByDictTypeCode(String dictTypeCode, String parentDictCode) {
        if (StringUtils.isEmpty(dictTypeCode)
                || StringUtils.isEmpty(parentDictCode)) {
            return null;
        }
        return this.dictDataVoFeign.findDictLowerByDictTypeCode(dictTypeCode, parentDictCode).getResult();
    }

    @Override
    public List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isEmpty(dictTypeCode)) {
            return Collections.emptyList();
        }
        return this.dictDataVoFeign.findByDictTypeCode(dictTypeCode).getResult();
    }

    @Override
    public DictDataVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        return this.dictDataVoFeign.findById(id).getResult();
    }

    @Override
    public DictDataVo findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode) {
        if (StringUtils.isEmpty(dictTypeCode)
                || StringUtils.isEmpty(dictCode)) {
            return null;
        }
        return this.dictDataVoFeign.findByDictTypeCodeAndDictCode(dictTypeCode, dictCode).getResult();
    }

  @Override
  public Map<String, List<DictDataVo>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
	  if (CollectionUtils.isEmpty(dictTypeCodeList)) {
            return Collections.emptyMap();
        }
    return this.dictDataVoFeign.findByDictTypeCodeList(dictTypeCodeList).getResult();
  }

    @Override
    public List<JSONObject> findContainExtendByConditions(DictDataDto dto) {
        if (Objects.isNull(dto)) {
            return Collections.emptyList();
        } if (StringUtils.isEmpty(dto.getDictTypeCode())
                && StringUtils.isEmpty(dto.getParentDictCode())
                && StringUtils.isEmpty(dto.getDictValue())) {
            return Collections.emptyList();
        }
        return this.dictDataVoFeign.findContainExtendByConditions(dto.getDictTypeCode(), dto.getParentDictCode(), dto.getDictValue()).getResult();
    }

    @Override
    public void save(DictDataDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(DictDataDto dto) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteByDictTypeCode(String dictTypeCode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteExtFieldVal(String dictTypeCode, List<String> extList) {
        throw new UnsupportedOperationException();
    }
}
