package com.biz.crm.mdm.business.dictionary.feign.service.internal;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictToolKitFeign;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;
import java.util.Map;

/**
 * @author huojia
 * @date 2022年11月09日 17:42
 */
@Service
public class DictToolKitServiceImpl implements DictToolkitService {

    @Resource
    private DictToolKitFeign dictToolKitFeign;

    @Override
    public List<DictDataVo> tree(String dictTypeCode) {
        Result<List<DictDataVo>> result = dictToolKitFeign.tree(dictTypeCode);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, String> findMapByDictTypeCode(String dictTypeCode) {
        Result<Map<String, String>> result = dictToolKitFeign.findMapByDictTypeCode(dictTypeCode);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public Map<String, String> findConvertMapByDictTypeCode(String dictTypeCode) {
        Result<Map<String, String>> result = dictToolKitFeign.findConvertMapByDictTypeCode(dictTypeCode);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }
}
