package com.biz.crm.mdm.business.dictionary.feign.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictTypeVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 数据字典类型 feign 实现
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2022.11.29 18:22
 */
@Service
public class DictTypeVoServiceImpl implements DictTypeVoService {

    @Autowired(required = false)
    private DictTypeVoFeign dictTypeVoFeign;


    /**
     * 分页获取数据字典类型列表
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.29 19:05
     */
    @Override
    public Page<DictTypeVo> findByConditions(Pageable pageable, DictTypeDto dto) {
        Result<Page<DictTypeVo>> result = this.dictTypeVoFeign.findByConditions(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


    /**
     * 分页获取数据字典类型列表 包含详细信息
     *
     * @param pageable
     * @param dto
     * @return com.baomidou.mybatisplus.extension.plugins.pagination.Page<com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo>
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.29 19:05
     */
    @Override
    public Page<DictTypeContainDataVo> listDictTypeContainDataPage(Pageable pageable, DictTypeContainDataDto dto) {
        Result<Page<DictTypeContainDataVo>> result = this.dictTypeVoFeign.listDictTypeContainDataPage(pageable.getPageNumber(), pageable.getPageSize(), dto);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }


    /**
     * 根据id获取数据字典详请
     *
     * @param id
     * @return com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.29 19:05
     */
    @Override
    public DictTypeVo findById(String id) {
        if (StringUtils.isEmpty(id)) {
            return null;
        }
        Result<DictTypeVo> result = this.dictTypeVoFeign.findById(id);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    /**
     * 根据dictTypeCode获取数据字典详请
     *
     * @param dictTypeCode 字典类型
     * @return com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2022.11.29 19:05
     */
    @Override
    public DictTypeVo findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isEmpty(dictTypeCode)) {
            return null;
        }
        Result<DictTypeVo> result = this.dictTypeVoFeign.findByDictTypeCode(dictTypeCode);
        Assert.isTrue(result.isSuccess(), result.getMessage());
        return result.getResult();
    }

    @Override
    public void save(DictTypeDto reqVo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void update(DictTypeDto reqVo) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void deleteBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void disableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }
}
