/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.mdm.business.dictionary.feign.feign.DictDataVoFeign;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="FeignDictDataVoServiceImpl")
public class DictDataVoServiceImpl
implements DictDataVoService {
    @Autowired(required=false)
    private DictDataVoFeign dictDataVoFeign;

    public List<DictDataVo> findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isEmpty((CharSequence)dictTypeCode)) {
            return Collections.emptyList();
        }
        return (List)this.dictDataVoFeign.findByDictTypeCode(dictTypeCode).getResult();
    }

    public List<DictDataVo> findDictLowerByDictTypeCode(String dictTypeCode, String parentDictCode) {
        if (StringUtils.isEmpty((CharSequence)dictTypeCode) || StringUtils.isEmpty((CharSequence)parentDictCode)) {
            return null;
        }
        return (List)this.dictDataVoFeign.findDictLowerByDictTypeCode(dictTypeCode, parentDictCode).getResult();
    }

    public List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isEmpty((CharSequence)dictTypeCode)) {
            return Collections.emptyList();
        }
        return (List)this.dictDataVoFeign.findByDictTypeCode(dictTypeCode).getResult();
    }

    public DictDataVo findById(String id) {
        if (StringUtils.isEmpty((CharSequence)id)) {
            return null;
        }
        return (DictDataVo)this.dictDataVoFeign.findById(id).getResult();
    }

    public DictDataVo findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode) {
        if (StringUtils.isEmpty((CharSequence)dictTypeCode) || StringUtils.isEmpty((CharSequence)dictCode)) {
            return null;
        }
        return (DictDataVo)this.dictDataVoFeign.findByDictTypeCodeAndDictCode(dictTypeCode, dictCode).getResult();
    }

    public Map<String, List<DictDataVo>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
        if (CollectionUtils.isEmpty(dictTypeCodeList)) {
            return Collections.emptyMap();
        }
        return (Map)this.dictDataVoFeign.findByDictTypeCodeList(dictTypeCodeList).getResult();
    }

    public List<JSONObject> findContainExtendByConditions(DictDataDto dto) {
        if (Objects.isNull(dto)) {
            return Collections.emptyList();
        }
        if (StringUtils.isEmpty((CharSequence)dto.getDictTypeCode()) && StringUtils.isEmpty((CharSequence)dto.getParentDictCode()) && StringUtils.isEmpty((CharSequence)dto.getDictValue())) {
            return Collections.emptyList();
        }
        return (List)this.dictDataVoFeign.findContainExtendByConditions(dto.getDictTypeCode(), dto.getParentDictCode(), dto.getDictValue()).getResult();
    }

    public void save(DictDataDto dto) {
        throw new UnsupportedOperationException();
    }

    public void update(DictDataDto dto) {
        throw new UnsupportedOperationException();
    }

    public void deleteBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    public void enableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    public void disableBatch(List<String> ids) {
        throw new UnsupportedOperationException();
    }

    public void deleteByDictTypeCode(String dictTypeCode) {
        throw new UnsupportedOperationException();
    }

    public void deleteExtFieldVal(String dictTypeCode, List<String> extList) {
        throw new UnsupportedOperationException();
    }
}

