package com.biz.crm.mdm.business.dictionary.feign.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.feign.feign.internal.DictDataVoFeignFallbackImpl;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Map;

/**
 * 数据字典feign接口类
 *
 * @author ning.zhang
 * @date 2022/2/18
 */
@FeignClient(
    name = "${feign.urlip:crm-mdm}",
    path = "crm-mdm",
    fallbackFactory = DictDataVoFeignFallbackImpl.class)
public interface DictDataVoFeign {

  /**
   * 根据数据字典类型编码集合获取数据字典信息
   *
   * @param dictTypeCodeList 数据字典类型编码集合
   * @return 数据字典信息
   */
  @GetMapping("/v1/dictionary/dictdata/findByDictTypeCodeList")
  Result<Map<String, List<DictDataVo>>> findByDictTypeCodeList(@RequestParam(value = "dictTypeCodeList") List<String> dictTypeCodeList);

  /**
   * 根据dictTypeCode获取字段数据列表
   *
   * @param dictTypeCode dict类型代码
   * @return {@link Result}<{@link List}<{@link DictDataVo}>>
   */
  @GetMapping("/v1/dictionary/dictdata/findByDictTypeCode")
  Result<List<DictDataVo>> findByDictTypeCode(@RequestParam(value = "dictTypeCode") String dictTypeCode);
}
