/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.controller;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dictionary/dictdata"})
@Api(tags={"\u6570\u636e\u5b57\u5178\uff1a\u660e\u7ec6\u7ba1\u7406\uff1aDictDataVo"})
public class DictDataVoController {
    private static final Logger log = LoggerFactory.getLogger(DictDataVoController.class);
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    @ApiOperation(value="\uff08\u5b57\u5178\u7ef4\u62a4\u9875\u9762\u4e13\u7528\uff09\u6811\u5f62\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/findTreeByDictTypeCode"})
    public Result<List<DictDataVo>> findTreeByDictTypeCode(@RequestParam String dictTypeCode) {
        try {
            List result = this.dictDataVoService.findTreeByDictTypeCode(dictTypeCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/findById"})
    public Result<DictDataVo> findById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.dictDataVoService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u548c\u5b57\u5178\u7f16\u7801\u67e5\u8be2\u8be6\u60c5", httpMethod="GET")
    @GetMapping(value={"/findByDictTypeCodeAndDictCode"})
    public Result<DictDataVo> findByDictTypeCodeAndDictCode(@RequestParam(value="dictTypeCode") String dictTypeCode, @RequestParam(value="dictCode") String dictCode) {
        try {
            return Result.ok((Object)this.dictDataVoService.findByDictTypeCodeAndDictCode(dictTypeCode, dictCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e", httpMethod="POST")
    @PostMapping
    public Result<?> create(@RequestBody DictDataDto dto) {
        try {
            this.dictDataVoService.save(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0", httpMethod="PATCH")
    @PatchMapping
    public Result<?> update(@RequestBody DictDataDto dto) {
        try {
            this.dictDataVoService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam List<String> ids) {
        try {
            this.dictDataVoService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.dictDataVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.dictDataVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5305\u542b\u6269\u5c55\u5b57\u6bb5\u7684\u6570\u636e\u5b57\u5178\u4e0b\u62c9", notes="dictTypeCode\u5fc5\u4f20\uff0c\u8fd4\u56de\u503c\u91ccdictCode:\u7f16\u7801\uff1bdictValue:\u503c\uff08\u6a21\u7cca\u67e5\u8be2\uff09\uff0c\u5176\u4f59\u4e3a\u6269\u5c55\u5b57\u6bb5", httpMethod="GET")
    @GetMapping(value={"/findContainExtendByConditions"})
    public Result<List<JSONObject>> findContainExtendByConditions(@RequestParam(value="dictTypeCode", required=true) String dictTypeCode, @RequestParam(value="parentDictCode", required=false) String parentDictCode, @RequestParam(value="dictValue", required=false) String dictValue) {
        try {
            DictDataDto dto = new DictDataDto();
            dto.setParentDictCode(parentDictCode);
            dto.setDictTypeCode(dictTypeCode);
            dto.setDictValue(dictValue);
            return Result.ok((Object)this.dictDataVoService.findContainExtendByConditions(dto));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6279\u91cf\u83b7\u53d6\u6570\u636e\u5b57\u5178\u4e0b\u62c9\u6846", notes="\u8fd4\u56de\u503c\u6ca1\u6709\u6269\u5c55\u5b57\u6bb5\uff0c\u4f20\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u96c6\u5408\u6570\u7ec4", httpMethod="GET")
    @GetMapping(value={"/findByDictTypeCodeList"})
    public Result<Map<String, List<DictDataVo>>> findByDictTypeCodeList(@RequestParam(value="dictTypeCodeList", required=false) List<String> dictTypeCodeList) {
        try {
            return Result.ok((Object)this.dictDataVoService.findByDictTypeCodeList(dictTypeCodeList));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636edictTypeCode\u83b7\u53d6\u5b57\u6bb5\u6570\u636e\u5217\u8868", notes="\u8fd4\u56de\u503c\u6ca1\u6709\u6269\u5c55\u5b57\u6bb5\uff0c\u4f20\u5b57\u5178\u7c7b\u578b\u7f16\u7801", httpMethod="GET")
    @GetMapping(value={"/findByDictTypeCode"})
    public Result<List<DictDataVo>> findByDictTypeCode(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        try {
            return Result.ok((Object)this.dictDataVoService.findByDictTypeCode(dictTypeCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u5b57\u5178\u4e0b\u7ea7", notes="\u8fd4\u56de\u503c\u6ca1\u6709\u6269\u5c55\u5b57\u6bb5\uff0c\u4f20\u5b57\u5178\u7c7b\u578b\u7f16\u7801", httpMethod="GET")
    @GetMapping(value={"/findDictLowerByDictTypeCode"})
    public Result<List<DictDataVo>> findDictLowerByDictTypeCode(@RequestParam(value="dictTypeCode", required=true) String dictTypeCode, @RequestParam(value="parentDictCode", required=true) String parentDictCode) {
        try {
            return Result.ok((Object)this.dictDataVoService.findDictLowerByDictTypeCode(dictTypeCode, parentDictCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

