/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dictionary/toolkit"})
@Api(tags={"\u6570\u636e\u5b57\u5178"})
public class DictToolKitController {
    private static final Logger log = LoggerFactory.getLogger(DictToolKitController.class);
    @Resource
    private DictToolkitService dictToolkitService;

    @ApiOperation(value="\u6811\u5f62\u5217\u8868", httpMethod="GET")
    @GetMapping(value={"/tree"})
    public Result<List<DictDataVo>> tree(@RequestParam String dictTypeCode) {
        try {
            List result = this.dictToolkitService.tree(dictTypeCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="MAP", httpMethod="GET")
    @GetMapping(value={"/findMapByDictTypeCode"})
    public Result<Map<String, String>> findMapByDictTypeCode(@RequestParam String dictTypeCode) {
        try {
            Map result = this.dictToolkitService.findMapByDictTypeCode(dictTypeCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="MAP", httpMethod="GET")
    @GetMapping(value={"/findConvertMapByDictTypeCode"})
    public Result<Map<String, String>> findConvertMapByDictTypeCode(@RequestParam String dictTypeCode) {
        try {
            Map result = this.dictToolkitService.findConvertMapByDictTypeCode(dictTypeCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

