/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictAttrConfEntity;
import com.biz.crm.mdm.business.dictionary.local.mapper.DictAttrConfMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DictAttrConfRepository
extends ServiceImpl<DictAttrConfMapper, DictAttrConfEntity> {
    public List<DictAttrConfEntity> findByDictAttrConfCode(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCode") String dictTypeCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(DictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc(DictAttrConfEntity::getShowOrder);
        return ((DictAttrConfMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<DictAttrConfEntity> findByDictTypeCodes(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCodes") Collection<String> dictTypeCodes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(DictAttrConfEntity::getDictTypeCode, dictTypeCodes);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc(DictAttrConfEntity::getShowOrder);
        return ((DictAttrConfMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictAttrConfMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateDelFlagByIdIn(DelFlagStatusEnum delFlag, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)delFlag.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictAttrConfMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateByIdAndTenantCode(DictAttrConfEntity entity, String tenantCode) {
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{entity.getId()});
        ((DictAttrConfMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public DictAttrConfEntity findByIdAndTenantCode(String id, String tenantCode) {
        return (DictAttrConfEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }
}

