/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictTypeEntity;
import com.biz.crm.mdm.business.dictionary.local.mapper.DictTypeMapper;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import jodd.util.StringUtil;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.ibatis.annotations.Param;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DictTypeRepository
extends ServiceImpl<DictTypeMapper, DictTypeEntity> {
    public Page<DictTypeVo> findByConditions(Pageable pageable, @Param(value="dto") DictTypeDto dto) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DictTypeDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((DictTypeMapper)this.baseMapper).findByConditions((Page<DictTypeEntity>)page, dto);
    }

    public Page<DictTypeContainDataVo> listDictTypeContainDataPage(Pageable pageable, DictTypeContainDataDto dto, List<String> dictTypeNotInList) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        dto = Optional.ofNullable(dto).orElse(new DictTypeContainDataDto());
        dto.setTenantCode(TenantUtils.getTenantCode());
        Page page = new Page((long)pageable.getPageNumber(), (long)pageable.getPageSize());
        return ((DictTypeMapper)this.baseMapper).listDictTypeContainDataPage((Page<DictTypeContainDataVo>)page, dto, dictTypeNotInList);
    }

    public List<DictTypeEntity> findAllDictType(@Param(value="tenantCode") String tenantCode) {
        if (StringUtil.isEmpty((CharSequence)tenantCode)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        return ((DictTypeMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<DictTypeEntity> findByDictTypeCodes(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCodes") Collection<String> dictTypeCodes) {
        if (StringUtil.isEmpty((CharSequence)tenantCode) || CollectionUtils.isEmpty(dictTypeCodes)) {
            return Collections.emptyList();
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(DictTypeEntity::getDictTypeCode, dictTypeCodes);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        return ((DictTypeMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public DictTypeEntity findByDictTypeCode(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCode") String dictTypeCode) {
        if (StringUtil.isEmpty((CharSequence)tenantCode) || StringUtil.isEmpty((CharSequence)dictTypeCode)) {
            return null;
        }
        return (DictTypeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).eq(DictTypeEntity::getDictTypeCode, (Object)dictTypeCode)).eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode())).one());
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids) || Objects.isNull(enable)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictTypeMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateDelFlagByIdIn(DelFlagStatusEnum delFlag, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids) || Objects.isNull(delFlag)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)delFlag.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictTypeMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateByIdAndTenantCode(DictTypeEntity entity, String tenantCode) {
        if (Objects.isNull((Object)entity) || StringUtil.isEmpty((CharSequence)tenantCode)) {
            return;
        }
        LambdaUpdateWrapper lambdaUpdateWrapper = Wrappers.lambdaUpdate();
        lambdaUpdateWrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        lambdaUpdateWrapper.in(UuidEntity::getId, new Object[]{entity.getId()});
        ((DictTypeMapper)this.baseMapper).update((Object)entity, (Wrapper)lambdaUpdateWrapper);
    }

    public DictTypeEntity findByIdAndTenantCode(String id, String tenantCode) {
        if (StringUtil.isEmpty((CharSequence)id) || StringUtil.isEmpty((CharSequence)tenantCode)) {
            return null;
        }
        return (DictTypeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, new Object[]{id})).one());
    }

    public List<DictTypeEntity> listByIdsAndTenantCode(List<String> ids, String tenantCode) {
        if (CollectionUtils.isEmpty(ids) || StringUtil.isEmpty((CharSequence)tenantCode)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode)).in(UuidEntity::getId, ids)).list();
    }
}

