/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictDataEntity;
import com.biz.crm.mdm.business.dictionary.local.mapper.DictDataMapper;
import com.biz.crm.mdm.business.dictionary.local.repository.DictDataRepository;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventBatchDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataNebulaEventUpdateDto;
import com.biz.crm.mdm.business.dictionary.sdk.event.DictDataEventListener;
import com.biz.crm.mdm.business.dictionary.sdk.event.DictDataNebulaEventListener;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictAttrConfVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictAttrConfVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ReflectionUtils;

@Service
public class DictDataVoServiceImpl
implements DictDataVoService {
    @Autowired(required=false)
    private DictDataRepository dictDataRepository;
    @Autowired(required=false)
    private DictTypeVoService dictTypeVoService;
    @Autowired(required=false)
    private DictAttrConfVoService dictAttrConfVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<DictDataEventListener> dictDataEventListeners;
    @Autowired(required=false)
    private NebulaNetEventClient nebulaNetEventClient;
    private static volatile Cache<String, List<DictDataVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DictDataVoServiceImpl() {
        if (cache != null) return;
        Class<DictDataVoServiceImpl> clazz = DictDataVoServiceImpl.class;
        synchronized (DictDataVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<DictDataVo> findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            return new ArrayList<DictDataVo>();
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), dictTypeCode});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        List<DictDataEntity> entities = this.dictDataRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (CollectionUtils.isEmpty(entities)) {
            cache.put((Object)cacheKey, Collections.emptyList());
            return new ArrayList<DictDataVo>();
        }
        graph = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        this.setExtendMapVal(graph, dictTypeCode);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }

    public List<DictDataVo> findDictLowerByDictTypeCode(String dictTypeCode, String parentDictCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)parentDictCode)) {
            return new ArrayList<DictDataVo>();
        }
        String tenantCode = TenantUtils.getTenantCode();
        String cacheKey = StringUtils.join((Object[])new String[]{tenantCode, dictTypeCode, parentDictCode});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        List<DictDataEntity> entities = this.dictDataRepository.findDictLowerByDictTypeCode(tenantCode, dictTypeCode, parentDictCode);
        if (CollectionUtils.isEmpty(entities)) {
            cache.put((Object)cacheKey, Collections.emptyList());
            return new ArrayList<DictDataVo>();
        }
        graph = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }

    public List<DictDataVo> findTreeByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            return new ArrayList<DictDataVo>();
        }
        List<DictDataVo> voList = this.findByDictTypeCode(dictTypeCode);
        List confList = this.dictAttrConfVoService.findByDictTypeCode(dictTypeCode);
        Map<String, String> map = voList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
        confList.forEach(c -> voList.forEach(vo -> {
            if (StringUtils.equals((CharSequence)vo.getDictCode(), (CharSequence)c.getFieldCode()) && map.containsKey(vo.getDictCode())) {
                DictDataVoServiceImpl.setFieldValue(vo, c.getExtField(), map.get(vo.getDictCode()));
            }
        }));
        ArrayList<DictDataVo> result = new ArrayList<DictDataVo>(this.generateTree(voList));
        this.setExtendMapVal(voList, dictTypeCode);
        this.setPath(dictTypeCode, result);
        return result;
    }

    private DictDataVo setExtendMapVal(DictDataVo dataVo, String dictTypeCode) {
        if (Objects.isNull(dataVo) || StringUtils.isEmpty((CharSequence)dictTypeCode)) {
            return dataVo;
        }
        List<DictDataVo> dictDataVoList = this.setExtendMapVal(Collections.singletonList(dataVo), dictTypeCode);
        if (CollectionUtils.isNotEmpty(dictDataVoList)) {
            return dictDataVoList.get(0);
        }
        return dataVo;
    }

    private List<DictDataVo> setExtendMapVal(List<DictDataVo> voList, String dictTypeCode) {
        if (CollectionUtils.isEmpty(voList) || StringUtils.isEmpty((CharSequence)dictTypeCode)) {
            return new ArrayList<DictDataVo>();
        }
        List confList = this.dictAttrConfVoService.findByDictTypeCode(dictTypeCode);
        if (CollectionUtil.isEmpty((Collection)confList)) {
            return new ArrayList<DictDataVo>();
        }
        Map<String, String> confMap = confList.stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getExtField())).collect(Collectors.toMap(DictAttrConfVo::getExtField, DictAttrConfVo::getFieldCode, (oldValue, newValue) -> newValue));
        if (CollectionUtil.isEmpty(confMap)) {
            return new ArrayList<DictDataVo>();
        }
        voList.forEach(vo -> {
            HashMap extendMap = new HashMap(16);
            confMap.forEach((field, fieldCode) -> {
                Object obj = DictDataVoServiceImpl.getFieldValue(vo, field);
                String objValue = "";
                if (Objects.nonNull(obj)) {
                    objValue = obj.toString();
                }
                extendMap.put(fieldCode, objValue);
            });
            vo.setExtendMap(extendMap);
        });
        return voList;
    }

    private static Object getFieldValue(Object object, String filedName) {
        if (object == null || StringUtils.isBlank((CharSequence)filedName)) {
            return null;
        }
        Field field = ReflectionUtils.findField(object.getClass(), (String)filedName);
        if (field == null) {
            return null;
        }
        ReflectionUtils.makeAccessible((Field)field);
        return ReflectionUtils.getField((Field)field, (Object)object);
    }

    private static void setFieldValue(Object object, String filedName, Object value) {
        if (object == null || StringUtils.isBlank((CharSequence)filedName)) {
            return;
        }
        Field field = ReflectionUtils.findField(object.getClass(), (String)filedName);
        if (field == null) {
            return;
        }
        ReflectionUtils.makeAccessible((Field)field);
        ReflectionUtils.setField((Field)field, (Object)object, (Object)value);
    }

    public DictDataVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DictDataEntity entity = this.dictDataRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (entity == null) {
            return null;
        }
        DictDataVo dictDataVo = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return this.setExtendMapVal(dictDataVo, entity.getDictTypeCode());
    }

    public DictDataVo findByDictTypeCodeAndDictCode(String dictTypeCode, String dictCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        DictDataEntity entity = this.dictDataRepository.findByDictTypeCodeAndDictCode(TenantUtils.getTenantCode(), dictTypeCode, dictCode);
        if (entity == null) {
            return null;
        }
        DictDataVo dictDataVo = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
        return this.setExtendMapVal(dictDataVo, dictTypeCode);
    }

    public Map<String, List<DictDataVo>> findByDictTypeCodeList(List<String> dictTypeCodeList) {
        if (CollectionUtils.isEmpty(dictTypeCodeList)) {
            return new HashMap<String, List<DictDataVo>>();
        }
        HashMap<String, List<DictDataVo>> map = new HashMap<String, List<DictDataVo>>(dictTypeCodeList.size());
        for (String dictTypeCode : dictTypeCodeList) {
            List<DictDataVo> list = this.findTreeByDictTypeCode(dictTypeCode);
            map.put(dictTypeCode, list);
        }
        return map;
    }

    private List<DictDataVo> getChildrenList(String dictTypeCode, String dictCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode) || StringUtils.isBlank((CharSequence)dictCode)) {
            return new ArrayList<DictDataVo>();
        }
        List<DictDataVo> list = this.findTreeByDictTypeCode(dictTypeCode);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DictDataVo>();
        }
        return list.stream().peek(item -> item.setChildren(null)).collect(Collectors.toList());
    }

    public List<JSONObject> findContainExtendByConditions(DictDataDto dto) {
        if (dto == null) {
            dto = new DictDataDto();
        }
        if (StringUtils.isBlank((CharSequence)dto.getDictTypeCode())) {
            return new ArrayList<JSONObject>();
        }
        ArrayList<DictDataVo> list = new ArrayList<DictDataVo>();
        if (StringUtils.isNotBlank((CharSequence)dto.getParentDictCode())) {
            list.addAll(this.getChildrenList(dto.getDictTypeCode(), dto.getParentDictCode()));
        } else {
            list.addAll(this.findTreeByDictTypeCode(dto.getDictTypeCode()));
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<JSONObject>();
        }
        DictDataDto finalDto = dto;
        return list.stream().filter(item -> {
            if (StringUtils.isNotBlank((CharSequence)finalDto.getDictValue())) {
                return item.getDictValue().contains(finalDto.getDictValue());
            }
            return true;
        }).map(item -> {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("dictCode", (Object)item.getDictCode());
            jsonObject.put("dictValue", (Object)item.getDictValue());
            Map extendMap = item.getExtendMap();
            if (!extendMap.isEmpty()) {
                for (Map.Entry entry : extendMap.entrySet()) {
                    jsonObject.put((String)entry.getKey(), entry.getValue());
                }
            }
            return jsonObject;
        }).collect(Collectors.toList());
    }

    @Transactional
    public void save(DictDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u5b57\u5178\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getDictCode(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!dto.getDictCode().contains("/") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c/\u201d", (Object[])new Object[0]);
        Validate.isTrue((!dto.getDictCode().contains(",") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c,\u201d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictTypeCode(), (String)"\u5bf9\u5e94\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictTypeVo dict = this.dictTypeVoService.findByDictTypeCode(dto.getDictTypeCode());
        Validate.notNull((Object)dict, (String)"\u5bf9\u5e94\u5b57\u5178\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        DictDataEntity oldEntity = this.dictDataRepository.findByDictTypeCodeAndDictCode(TenantUtils.getTenantCode(), dto.getDictTypeCode(), dto.getDictCode());
        Validate.isTrue((boolean)Objects.isNull((Object)oldEntity), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getParentDictCode())) {
            DictDataEntity parent = this.dictDataRepository.findByDictTypeCodeAndDictCode(TenantUtils.getTenantCode(), dict.getDictTypeCode(), dto.getParentDictCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        DictDataEntity entity = (DictDataEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictDataEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setParentDictCode(Optional.ofNullable(dto.getParentDictCode()).orElse(""));
        this.dictDataRepository.save((Object)entity);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            DictDataVo vo = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onCreate(vo));
        }
        DictDataNebulaEventDto dictDataNebulaEventDto = (DictDataNebulaEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onCreate;
        this.nebulaNetEventClient.publish((NebulaEventDto)dictDataNebulaEventDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void update(DictDataDto dto) {
        Validate.notNull((Object)dto, (String)"\u5b57\u5178\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getId(), (String)"ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictDataEntity oldEntity = (DictDataEntity)((Object)this.dictDataRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictCode(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictTypeCode(), (String)"\u5bf9\u5e94\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getDictCode().equals(dto.getDictCode()), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getDictTypeCode().equals(dto.getDictTypeCode()), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        DictDataEntity excludeEntity = this.dictDataRepository.findByDictTypeCodeAndDictCode(TenantUtils.getTenantCode(), dto.getDictTypeCode(), dto.getDictCode());
        Validate.notNull((Object)((Object)excludeEntity), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u5b58\u5728\u6216\u5df2\u5220\u9664", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)excludeEntity.getId(), (CharSequence)dto.getId()), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u5b58\u5728", (Object[])new Object[0]);
        if (StringUtils.isNotBlank((CharSequence)dto.getParentDictCode())) {
            DictDataEntity parent = this.dictDataRepository.findByDictTypeCodeAndDictCode(TenantUtils.getTenantCode(), oldEntity.getDictTypeCode(), dto.getParentDictCode());
            Validate.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        }
        DictDataEntity entity = (DictDataEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictDataEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setParentDictCode(Optional.ofNullable(dto.getParentDictCode()).orElse(""));
        this.dictDataRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            DictDataVo oldVo = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            DictDataVo newVo = (DictDataVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onChange(oldVo, newVo));
        }
        DictDataNebulaEventDto oldDictDataNebulaEventDto = (DictDataNebulaEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        DictDataNebulaEventDto newDictDataNebulaEventDto = (DictDataNebulaEventDto)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]);
        DictDataNebulaEventUpdateDto nebulaEventUpdateDto = new DictDataNebulaEventUpdateDto();
        nebulaEventUpdateDto.setOldDictDataNebulaEventDto(oldDictDataNebulaEventDto);
        nebulaEventUpdateDto.setNewDictDataNebulaEventDto(newDictDataNebulaEventDto);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onUpdate;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventUpdateDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = ((DictDataMapper)this.dictDataRepository.getBaseMapper()).selectBatchIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        List<String> dictCodeList = entities.stream().map(DictDataEntity::getDictCode).collect(Collectors.toList());
        List<DictDataEntity> children = this.dictDataRepository.findByParentDictCodes(TenantUtils.getTenantCode(), dictCodeList);
        if (CollectionUtils.isNotEmpty(children)) {
            List collect = children.stream().map(UuidEntity::getId).filter(ids::contains).collect(Collectors.toList());
            Validate.isTrue((boolean)CollectionUtils.isEmpty(collect), (String)"\u5b57\u5178\u5b58\u5728\u4e0b\u7ea7\u4e0d\u80fd\u5220\u9664\uff01", (Object[])new Object[0]);
        }
        this.dictDataRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onDelete(voList));
        }
        ArrayList nebulaEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        DictDataNebulaEventBatchDto nebulaEventBatchDto = new DictDataNebulaEventBatchDto();
        nebulaEventBatchDto.setDictDataNebulaEventDtoList((List)nebulaEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventBatchDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = ((DictDataMapper)this.dictDataRepository.getBaseMapper()).selectBatchIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.dictDataRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onEnable(voList));
        }
        ArrayList nebulaEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        DictDataNebulaEventBatchDto nebulaEventBatchDto = new DictDataNebulaEventBatchDto();
        nebulaEventBatchDto.setDictDataNebulaEventDtoList((List)nebulaEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onEnable;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventBatchDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List entities = ((DictDataMapper)this.dictDataRepository.getBaseMapper()).selectBatchIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.dictDataRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onDisable(voList));
        }
        ArrayList nebulaEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictDataEntity.class, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        DictDataNebulaEventBatchDto nebulaEventBatchDto = new DictDataNebulaEventBatchDto();
        nebulaEventBatchDto.setDictDataNebulaEventDtoList((List)nebulaEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onDisable;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventBatchDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void deleteByDictTypeCode(String dictTypeCode) {
        Validate.notBlank((CharSequence)dictTypeCode, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DictDataEntity> entities = this.dictDataRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        Set<String> ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.dictDataRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.dictDataEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictDataEntity.class, DictDataVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictDataEventListeners.forEach(event -> event.onDelete(voList));
        }
        ArrayList nebulaEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictDataEntity.class, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        DictDataNebulaEventBatchDto nebulaEventBatchDto = new DictDataNebulaEventBatchDto();
        nebulaEventBatchDto.setDictDataNebulaEventDtoList((List)nebulaEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventBatchDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    @Transactional
    public void deleteExtFieldVal(String dictTypeCode, List<String> extList) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode) || CollectionUtils.isEmpty(extList)) {
            return;
        }
        List<DictDataEntity> list = this.dictDataRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(item -> extList.forEach(extField -> DictDataVoServiceImpl.setFieldValue(item, extField, "")));
        this.dictDataRepository.updateBatchById(list);
        ArrayList nebulaEventDtoList = Lists.newArrayList((Iterable)this.nebulaToolkitService.copyCollectionByWhiteList(list, DictDataEntity.class, DictDataNebulaEventDto.class, HashSet.class, ArrayList.class, new String[0]));
        DictDataNebulaEventBatchDto nebulaEventBatchDto = new DictDataNebulaEventBatchDto();
        nebulaEventBatchDto.setDictDataNebulaEventDtoList((List)nebulaEventDtoList);
        SerializableBiConsumer & Serializable nebulaEvent = DictDataNebulaEventListener::onDelete;
        this.nebulaNetEventClient.publish((NebulaEventDto)nebulaEventBatchDto, DictDataNebulaEventListener.class, (SerializableBiConsumer)nebulaEvent);
    }

    private List<DictDataVo> generateTree(List<DictDataVo> totalList) {
        ArrayList<DictDataVo> treeList = new ArrayList<DictDataVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, DictDataVo> totalMap = totalList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, v -> v));
        for (DictDataVo item : totalList) {
            if (StringUtils.isBlank((CharSequence)item.getParentDictCode()) || !totalMap.containsKey(item.getParentDictCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<DictDataVo> restTempList = new ArrayList<DictDataVo>();
            ArrayList<DictDataVo> curLevelTempList = new ArrayList<DictDataVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictCode));
            LinkedHashMap curLevelChildrenMap = new LinkedHashMap(16);
            for (DictDataVo dictDataVo : restList) {
                if (curLevelMap.containsKey(dictDataVo.getParentDictCode())) {
                    curLevelTempList.add(dictDataVo);
                    ArrayList<DictDataVo> childrenList = new ArrayList<DictDataVo>();
                    if (curLevelChildrenMap.containsKey(dictDataVo.getParentDictCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(dictDataVo.getParentDictCode()));
                    }
                    childrenList.add(dictDataVo);
                    curLevelChildrenMap.put(dictDataVo.getParentDictCode(), childrenList);
                    continue;
                }
                restTempList.add(dictDataVo);
            }
            for (DictDataVo dictDataVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(dictDataVo.getDictCode())) continue;
                dictDataVo.setChildren((List)curLevelChildrenMap.get(dictDataVo.getDictCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    private void setPath(String dictTypeCode, List<DictDataVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        for (DictDataVo item : list) {
            item.setPath(dictTypeCode + "/" + item.getDictCode());
            if (!CollectionUtils.isNotEmpty((Collection)item.getChildren())) continue;
            this.setPath(item.getPath(), item.getChildren());
        }
    }
}

