/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.service.internal;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictToolkitServiceImpl
implements DictToolkitService {
    @Autowired(required=false)
    private DictDataVoService dictDataVoService;

    public List<DictDataVo> tree(String dictTypeCode) {
        return this.dictDataVoService.findTreeByDictTypeCode(dictTypeCode);
    }

    public Map<String, String> findMapByDictTypeCode(String dictTypeCode) {
        List list = this.dictDataVoService.findByDictTypeCode(dictTypeCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
    }

    public Map<String, String> findConvertMapByDictTypeCode(String dictTypeCode) {
        List list = this.dictDataVoService.findByDictTypeCode(dictTypeCode);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(DictDataVo::getDictValue, DictDataVo::getDictCode));
    }
}

