/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.service.internal;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictTypeEntity;
import com.biz.crm.mdm.business.dictionary.local.repository.DictTypeRepository;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeContainDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.event.DictTypeEventListener;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictAttrConfVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeContainDataVo;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictTypeVoServiceImpl
implements DictTypeVoService {
    @Autowired(required=false)
    private DictTypeRepository dictTypeRepository;
    @Autowired(required=false)
    private DictAttrConfVoService dictAttrConfVoService;
    @Autowired(required=false)
    @Lazy
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<DictTypeEventListener> dictTypeEventListeners;

    public Page<DictTypeVo> findByConditions(Pageable pageable, DictTypeDto reqVo) {
        return this.dictTypeRepository.findByConditions(pageable, reqVo);
    }

    public Page<DictTypeContainDataVo> listDictTypeContainDataPage(Pageable pageable, DictTypeContainDataDto dto) {
        ArrayList<String> dictTypeNotInList = new ArrayList<String>();
        Page<DictTypeContainDataVo> pageList = this.dictTypeRepository.listDictTypeContainDataPage(pageable, dto, dictTypeNotInList);
        if (CollectionUtil.isEmpty((Collection)pageList.getRecords())) {
            return pageList;
        }
        List dictTypeCodeList = pageList.getRecords().stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDictTypeCode())).distinct().map(DictTypeContainDataVo::getDictTypeCode).collect(Collectors.toList());
        if (CollectionUtil.isEmpty(dictTypeCodeList)) {
            return pageList;
        }
        Map dictDataMap = this.dictDataVoService.findByDictTypeCodeList(dictTypeCodeList);
        if (CollectionUtil.isEmpty((Map)dictDataMap)) {
            return pageList;
        }
        pageList.getRecords().stream().filter(k -> StringUtils.isNotBlank((CharSequence)k.getDictTypeCode())).forEach(vo -> vo.setDataList((List)dictDataMap.get(vo.getDictTypeCode())));
        return pageList;
    }

    public DictTypeVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DictTypeEntity entity = this.dictTypeRepository.findByIdAndTenantCode(id, TenantUtils.getTenantCode());
        if (entity == null) {
            return null;
        }
        return (DictTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DictTypeVo findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            return null;
        }
        DictTypeEntity entity = this.dictTypeRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (entity == null) {
            return null;
        }
        return (DictTypeVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void save(DictTypeDto dto) {
        Validate.notNull((Object)dto, (String)"\u5b57\u5178\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        dto.setId(null);
        Validate.notBlank((CharSequence)dto.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((!dto.getDictTypeCode().contains("/") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c/\u201d", (Object[])new Object[0]);
        Validate.isTrue((!dto.getDictTypeCode().contains(",") ? 1 : 0) != 0, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u5b57\u7b26\u201c,\u201d", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictTypeModule(), (String)"\u6a21\u5757\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictTypeEntity oldEntity = this.dictTypeRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dto.getDictTypeCode());
        Validate.isTrue((boolean)Objects.isNull((Object)oldEntity), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728", (Object[])new Object[0]);
        DictTypeEntity entity = (DictTypeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictTypeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setTenantCode(TenantUtils.getTenantCode());
        this.dictTypeRepository.save((Object)entity);
    }

    @Transactional
    public void update(DictTypeDto reqVo) {
        Validate.notNull((Object)reqVo, (String)"\u5b57\u5178\u7c7b\u578b\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reqVo.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reqVo.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)reqVo.getDictTypeModule(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictTypeEntity oldEntity = this.dictTypeRepository.findByIdAndTenantCode(reqVo.getId(), TenantUtils.getTenantCode());
        Validate.notNull((Object)((Object)oldEntity), (String)"id\u65e0\u6548", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        DictTypeEntity entity = (DictTypeEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)reqVo, DictTypeEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.dictTypeRepository.updateByIdAndTenantCode(entity, TenantUtils.getTenantCode());
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (Object[])new Object[0]);
        List<DictTypeEntity> entities = this.dictTypeRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        entities.forEach(item -> {
            this.dictAttrConfVoService.deleteByDictTypeCode(item.getDictTypeCode());
            this.dictDataVoService.deleteByDictTypeCode(item.getDictTypeCode());
        });
        this.dictTypeRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.dictTypeEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictTypeEntity.class, DictTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictTypeEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    @Transactional
    public void enableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (Object[])new Object[0]);
        List<DictTypeEntity> entities = this.dictTypeRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.dictTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.ENABLE, ids);
        if (CollectionUtils.isNotEmpty(this.dictTypeEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictTypeEntity.class, DictTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictTypeEventListeners.forEach(event -> event.onEnable(voList));
        }
    }

    @Transactional
    public void disableBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e", (Object[])new Object[0]);
        List<DictTypeEntity> entities = this.dictTypeRepository.listByIdsAndTenantCode(ids, TenantUtils.getTenantCode());
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty(entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        this.dictTypeRepository.updateEnableStatusByIdIn(EnableStatusEnum.DISABLE, ids);
        if (CollectionUtils.isNotEmpty(this.dictTypeEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictTypeEntity.class, DictTypeVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictTypeEventListeners.forEach(event -> event.onDisable(voList));
        }
    }
}

