package com.biz.crm.mdm.business.dictionary.local.deprecated;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.dto.MdmDictAttrConfReqVo;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.vo.MdmDictAttrConfRespVo;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictAttrConfDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictAttrConfVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictAttrConfVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

/**
 * 数据字典扩展字段配置表
 *
 * @author pengxi
 */
@Slf4j
@RestController
@RequestMapping("/mdmdictattrconf")
@Api(tags = "MDM-数据字典-扩展字段配置表")
@Deprecated
public class MdmDictAttrConfController {
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private DictAttrConfVoService dictAttrConfVoService;

  private DictAttrConfDto transDto(MdmDictAttrConfReqVo reqVo) {
    return this.nebulaToolkitService.copyObjectByWhiteList(reqVo, DictAttrConfDto.class, HashSet.class, ArrayList.class);
  }

  private List<MdmDictAttrConfRespVo> transVoList(List<DictAttrConfVo> result) {
    return (List<MdmDictAttrConfRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result, DictAttrConfVo.class, MdmDictAttrConfRespVo.class, HashSet.class, ArrayList.class);
  }

  @ApiImplicitParams({
      @ApiImplicitParam(name = "dictTypeCode", value = "字典类型", required = true, paramType = "query")
  })
  @ApiOperation(value = "查询列表")
  @PostMapping("/list")
  public Result<List<MdmDictAttrConfRespVo>> list(@RequestParam("dictTypeCode") String dictTypeCode) {
    try {
      List<DictAttrConfVo> result = dictAttrConfVoService.findByDictTypeCode(dictTypeCode);
      if (CollectionUtils.isEmpty(result)) {
        return Result.ok(new ArrayList<>());
      }
      return Result.ok(this.transVoList(result));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询扩展字段列表")
  @PostMapping("/findAttrConfList")
  public Result<List<MdmDictAttrConfRespVo>> findAttrConfList(@RequestBody MdmDictAttrConfReqVo reqVo) {
    try {
      List<DictAttrConfVo> result = dictAttrConfVoService.findByDictTypeCode(reqVo.getDictTypeCode());
      if (CollectionUtils.isEmpty(result)) {
        return Result.ok(new ArrayList<>());
      }
      return Result.ok(this.transVoList(result));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "详情", httpMethod = "GET", notes = "查询详情")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/query")
  public Result<MdmDictAttrConfRespVo> query(@RequestParam(value = "id", required = true) String id) {
    try {
      MdmDictAttrConfRespVo respVo = null;
      DictAttrConfVo vo = dictAttrConfVoService.findById(id);
      if (Objects.nonNull(vo)) {
        respVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, MdmDictAttrConfRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(respVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result save(@RequestBody MdmDictAttrConfReqVo reqVo) {
    try {
      dictAttrConfVoService.save(this.transDto(reqVo));
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody MdmDictAttrConfReqVo reqVo) {
    try {
      dictAttrConfVoService.update(this.transDto(reqVo));
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    try {
      dictAttrConfVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }
}
