package com.biz.crm.mdm.business.dictionary.local.deprecated;

import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.dto.MdmDictDataReqVo;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.dto.MdmDictDataSelectReqVo;
import com.biz.crm.mdm.business.dictionary.sdk.deprecated.vo.MdmDictDataRespVo;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictDataDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

/**
 * 数据字典明细表
 *
 * @author pengxi
 */
@Slf4j
@RestController
@RequestMapping("/mdmdictdata")
@Api(tags = "MDM-数据字典-明细表")
@Deprecated
public class MdmDictDataController {
  @Autowired(required = false)
  @Qualifier("nebulaToolkitService")
  private NebulaToolkitService nebulaToolkitService;
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  private DictDataDto transDto(MdmDictDataReqVo reqVo) {
    return this.nebulaToolkitService.copyObjectByWhiteList(reqVo, DictDataDto.class, HashSet.class, ArrayList.class);
  }

  private List<MdmDictDataRespVo> transVoList(List<DictDataVo> result) {
    return (List<MdmDictDataRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result, DictDataVo.class, MdmDictDataRespVo.class, HashSet.class, ArrayList.class);
  }

  @ApiOperation(value = "（字典维护页面专用）树形列表", notes = "dictTypeCode必传")
  @PostMapping("/treeList")
  public Result<List<MdmDictDataRespVo>> treeList(@RequestBody MdmDictDataReqVo reqVo) {
    try {
      List<DictDataVo> result = dictDataVoService.findTreeByDictTypeCode(reqVo.getDictTypeCode());
      if (CollectionUtils.isEmpty(result)) {
        return Result.ok(new ArrayList<>());
      }
      List<MdmDictDataRespVo> voList = (List<MdmDictDataRespVo>) this.nebulaToolkitService.copyCollectionByWhiteList(result, DictDataVo.class, MdmDictDataRespVo.class, HashSet.class, ArrayList.class);
      return Result.ok(voList);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "树形列表，从缓存查询", notes = "dictTypeCode必传")
  @PostMapping("/tree")
  public Result<List<MdmDictDataRespVo>> tree(@RequestBody MdmDictDataReqVo reqVo) {
    try {
      List<DictDataVo> result = dictDataVoService.findTreeByDictTypeCode(reqVo.getDictTypeCode());
      if (CollectionUtils.isEmpty(result)) {
        return Result.ok(new ArrayList<>());
      }
      return Result.ok(this.transVoList(result));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询列表（树形），从缓存查，业务使用", httpMethod = "GET", notes = "dictTypeCode必传")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "dictTypeCode", value = "字典类型编码", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/dictTree")
  public Result<List<MdmDictDataRespVo>> dictTree(@RequestParam("dictTypeCode") String dictTypeCode) {
    try {
      List<com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo> result = dictDataVoService.findTreeByDictTypeCode(dictTypeCode);
      if (CollectionUtils.isEmpty(result)) {
        return Result.ok(new ArrayList<>());
      }
      return Result.ok(this.transVoList(result));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "批量获取数据字典下拉框", notes = "从缓存查询，返回值没有扩展字段，传字典类型编码集合数组", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "dictTypeCodeList", value = "字典类型编码集合", required = true, paramType = "body")
  })
  @PostMapping("/batchDictSelect")
  public Result<Map<String, List<DictDataVo>>> batchDictSelect(@RequestBody List<String> dictTypeCodeList) {
    // TODO DictDataVo >> MdmDictDataSelectRespVo
    try {
      return Result.ok(dictDataVoService.findByDictTypeCodeList(dictTypeCodeList));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "数据字典下拉框", notes = "从缓存查询，dictTypeCode必传，返回值里dictCode:编码；dictValue:值（模糊查询），其余为扩展字段")
  @PostMapping("/list")
  public Result<List<JSONObject>> list(@RequestBody MdmDictDataSelectReqVo reqVo) {
    try {
      DictDataDto dto = this.nebulaToolkitService.copyObjectByWhiteList(reqVo, DictDataDto.class, HashSet.class, ArrayList.class);
      return Result.ok(dictDataVoService.findContainExtendByConditions(dto));
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "查询详情", httpMethod = "GET", notes = "只查询数据字典类型")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "query")
  })
  @GetMapping("/query")
  public Result<MdmDictDataRespVo> query(String id) {
    try {
      MdmDictDataRespVo respVo = null;
      DictDataVo vo = dictDataVoService.findById(id);
      if (vo != null) {
        respVo = this.nebulaToolkitService.copyObjectByWhiteList(vo, MdmDictDataRespVo.class, HashSet.class, ArrayList.class);
      }
      return Result.ok(respVo);
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "新增")
  @PostMapping("/save")
  public Result save(@RequestBody MdmDictDataReqVo reqVo) {
    try {
      dictDataVoService.save(this.transDto(reqVo));
      return Result.ok();
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "更新")
  @PostMapping("/update")
  public Result update(@RequestBody MdmDictDataReqVo reqVo) {
    try {
      dictDataVoService.update(this.transDto(reqVo));
      return Result.ok("修改成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

  @ApiOperation(value = "删除", httpMethod = "POST")
  @ApiImplicitParams({
      @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
  })
  @PostMapping("/delete")
  public Result delete(@RequestBody List<String> ids) {
    try {
      dictDataVoService.deleteBatch(ids);
      return Result.ok("删除成功");
    } catch (RuntimeException e) {
      log.error(e.getMessage(), e);
      return Result.error(e.getMessage());
    }
  }

}
