package com.biz.crm.mdm.business.dictionary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * 数据字典明细表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_dict_data",  indexes = {
    @Index(name = "mdm_dict_data_index1", columnList = "dict_code,dict_type_code,tenant_code")
})
@TableName(value = "mdm_dict_data")
@org.hibernate.annotations.Table(appliesTo = "mdm_dict_data", comment = "数据字典明细表实体类")
public class DictDataEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = -6146283165273176933L;

  @TableField(value = "dict_code")
  @Column(name = "dict_code", nullable = false, columnDefinition = "varchar(64) COMMENT '字典编码'")
  private String dictCode;

  @TableField(value = "dict_value")
  @Column(name = "dict_value", nullable = false, columnDefinition = "varchar(2000) COMMENT '字典名称'")
  private String dictValue;

  @TableField(value = "dict_desc")
  @Column(name = "dict_desc", columnDefinition = "varchar(255) COMMENT '字典描述'")
  private String dictDesc;

  @TableField(value = "dict_type_code")
  @Column(name = "dict_type_code", nullable = false, columnDefinition = "varchar(64) COMMENT '字典类型编码'")
  private String dictTypeCode;

  @TableField(value = "dict_sort")
  @Column(name = "dict_sort", nullable = false, columnDefinition = "smallint COMMENT '排序'")
  private Integer dictSort;

  @TableField(value = "parent_dict_code")
  @Column(name = "parent_dict_code", nullable = false, columnDefinition = "varchar(64) COMMENT '上级编码'")
  private String parentDictCode;

}
