package com.biz.crm.mdm.business.dictionary.local.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 数据字典类型表实体类
 *
 * @author Tao.Chen
 * @date 2020-11-20 15:00:54
 */
@Getter
@Setter
@EqualsAndHashCode(callSuper = false)
@Entity
@Table(name = "mdm_dict_type")
@TableName(value = "mdm_dict_type")
@org.hibernate.annotations.Table(appliesTo = "mdm_dict_type", comment = "数据字典类型表实体类")
public class DictTypeEntity extends TenantFlagOpEntity {
  private static final long serialVersionUID = -7730898044801341126L;

  @TableField(value = "dict_type_code")
  @Column(name = "dict_type_code", nullable = false, columnDefinition = "varchar(64) COMMENT '字典类型编码'")
  private String dictTypeCode;

  @TableField(value = "dict_type_name")
  @Column(name = "dict_type_name", nullable = false, columnDefinition = "varchar(128) COMMENT '字典类型名称'")
  private String dictTypeName;

  @TableField(value = "dict_type_desc")
  @Column(name = "dict_type_desc", nullable = false, columnDefinition = "varchar(255) COMMENT '字典类型描述'")
  private String dictTypeDesc;

  @TableField(value = "dict_type_module")
  @Column(name = "dict_type_module", nullable = false, columnDefinition = "varchar(64) COMMENT '字典类型所属模块'")
  private String dictTypeModule;

}
