package com.biz.crm.mdm.business.dictionary.local.service.internal;

import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictToolkitService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.google.common.collect.Maps;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 数据字典明细表接口实现
 * @author pengxi
 */
@Service
public class DictToolkitServiceImpl implements DictToolkitService {
  @Autowired(required = false)
  private DictDataVoService dictDataVoService;

  @Override
  public List<DictDataVo> tree(String dictTypeCode) {
    return dictDataVoService.findTreeByDictTypeCode(dictTypeCode);
  }

  @Override
  public Map<String, String> findMapByDictTypeCode(String dictTypeCode) {
    List<DictDataVo> list = dictDataVoService.findByDictTypeCode(dictTypeCode);
    if (CollectionUtils.isEmpty(list)) {
      return Maps.newHashMap();
    }
    return  list.stream().collect(Collectors.toMap(DictDataVo::getDictCode, DictDataVo::getDictValue));
  }
}
