/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictAttrConfDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictAttrConfVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictAttrConfVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dictionary/dictattrconf"})
@Api(tags={"\u6570\u636e\u5b57\u5178\uff1a\u5c5e\u6027\u6269\u5c55\u7ba1\u7406\uff1aDictAttrConfVo"})
public class DictAttrConfVoController {
    private static final Logger log = LoggerFactory.getLogger(DictAttrConfVoController.class);
    @Autowired(required=false)
    private DictAttrConfVoService dictAttrConfVoService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u5206\u9875\uff09", httpMethod="GET")
    @GetMapping(value={"/findByDictTypeCode"})
    public Result<List<DictAttrConfVo>> findByDictTypeCode(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        try {
            List result = this.dictAttrConfVoService.findByDictTypeCode(dictTypeCode);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2", httpMethod="GET")
    @GetMapping(value={"/findById"})
    public Result<DictAttrConfVo> findById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.dictAttrConfVoService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e", httpMethod="POST")
    @PostMapping
    public Result<?> create(@RequestBody DictAttrConfDto dto) {
        try {
            this.dictAttrConfVoService.save(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0", httpMethod="PATCH")
    @PatchMapping
    public Result<?> update(@RequestBody DictAttrConfDto dto) {
        try {
            this.dictAttrConfVoService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam List<String> ids) {
        try {
            this.dictAttrConfVoService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

