/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictTypeDto;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictTypeVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictTypeVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/dictionary/dicttype"})
@Api(tags={"\u6570\u636e\u5b57\u5178\uff1a\u7c7b\u578b\u7ba1\u7406\uff1aDictTypeVo"})
public class DictTypeVoController {
    private static final Logger log = LoggerFactory.getLogger(DictTypeVoController.class);
    @Autowired(required=false)
    private DictTypeVoService dictTypeVoService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868\uff08\u5206\u9875\uff09", httpMethod="GET")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<DictTypeVo>> findByConditions(@PageableDefault(value=50) Pageable pageable, DictTypeDto dto) {
        try {
            Page result = this.dictTypeVoService.findByConditions(pageable, dto);
            return Result.ok((Object)result);
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2", httpMethod="GET")
    @GetMapping(value={"/findById"})
    public Result<DictTypeVo> findById(@RequestParam(value="id") String id) {
        try {
            return Result.ok((Object)this.dictTypeVoService.findById(id));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7c7b\u578b\u67e5\u8be2", httpMethod="GET")
    @GetMapping(value={"/findByDictTypeCode"})
    public Result<DictTypeVo> findByDictTypeCode(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        try {
            return Result.ok((Object)this.dictTypeVoService.findByDictTypeCode(dictTypeCode));
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e", httpMethod="POST")
    @PostMapping
    public Result<?> create(@RequestBody DictTypeDto dto) {
        try {
            this.dictTypeVoService.save(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u66f4\u65b0", httpMethod="PATCH")
    @PatchMapping
    public Result<?> update(@RequestBody DictTypeDto dto) {
        try {
            this.dictTypeVoService.update(dto);
            return Result.ok();
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5220\u9664", httpMethod="DELETE")
    @DeleteMapping
    public Result<?> delete(@RequestParam List<String> ids) {
        try {
            this.dictTypeVoService.deleteBatch(ids);
            return Result.ok((String)"\u5220\u9664\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.dictTypeVoService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.dictTypeVoService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (RuntimeException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

