/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.repository;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictDataEntity;
import com.biz.crm.mdm.business.dictionary.local.mapper.DictDataMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DictDataRepository
extends ServiceImpl<DictDataMapper, DictDataEntity> {
    public List<DictDataEntity> findByParentDictCodes(@Param(value="tenantCode") String tenantCode, @Param(value="parentDictCodes") Collection<String> parentDictCodes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(DictDataEntity::getParentDictCode, parentDictCodes);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc(DictDataEntity::getDictSort);
        return ((DictDataMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public List<DictDataEntity> findByDictTypeCodes(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCodes") Collection<String> dictTypeCodes) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.in(DictDataEntity::getDictTypeCode, dictTypeCodes);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc(DictDataEntity::getDictSort);
        return ((DictDataMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public DictDataEntity findByDictTypeCodeAndDictCode(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCode") String dictTypeCode, @Param(value="dictCode") String dictCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(DictDataEntity::getDictTypeCode, (Object)dictTypeCode);
        wrapper.eq(DictDataEntity::getDictCode, (Object)dictCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        return (DictDataEntity)((Object)((DictDataMapper)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    public List<DictDataEntity> findByDictTypeCode(@Param(value="tenantCode") String tenantCode, @Param(value="dictTypeCode") String dictTypeCode) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(TenantFlagOpEntity::getTenantCode, (Object)tenantCode);
        wrapper.eq(DictDataEntity::getDictTypeCode, (Object)dictTypeCode);
        wrapper.eq(UuidFlagOpEntity::getDelFlag, (Object)DelFlagStatusEnum.NORMAL.getCode());
        wrapper.orderByAsc(DictDataEntity::getDictSort);
        return ((DictDataMapper)this.baseMapper).selectList((Wrapper)wrapper);
    }

    public void updateEnableStatusByIdIn(EnableStatusEnum enable, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getEnableStatus, (Object)enable.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictDataMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }

    public void updateDelFlagByIdIn(DelFlagStatusEnum delFlag, Collection<String> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return;
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.set(UuidFlagOpEntity::getDelFlag, (Object)delFlag.getCode())).in(UuidEntity::getId, ids)).eq(TenantFlagOpEntity::getTenantCode, (Object)TenantUtils.getTenantCode());
        ((DictDataMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
    }
}

