/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.mdm.business.dictionary.local.service.internal;

import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.dictionary.local.entity.DictAttrConfEntity;
import com.biz.crm.mdm.business.dictionary.local.entity.DictTypeEntity;
import com.biz.crm.mdm.business.dictionary.local.mapper.DictAttrConfMapper;
import com.biz.crm.mdm.business.dictionary.local.repository.DictAttrConfRepository;
import com.biz.crm.mdm.business.dictionary.local.repository.DictTypeRepository;
import com.biz.crm.mdm.business.dictionary.sdk.dto.DictAttrConfDto;
import com.biz.crm.mdm.business.dictionary.sdk.event.DictAttrConfEventListener;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictAttrConfVoService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictAttrConfVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DictAttrConfVoServiceImpl
implements DictAttrConfVoService {
    @Autowired(required=false)
    private DictAttrConfRepository dictAttrConfRepository;
    @Autowired(required=false)
    private DictTypeRepository dictTypeRepository;
    @Autowired(required=false)
    @Lazy
    private DictDataVoService dictDataVoService;
    @Autowired(required=false)
    @Qualifier(value="nebulaToolkitService")
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    @Lazy
    private List<DictAttrConfEventListener> dictAttrConfEventListeners;
    private static volatile Cache<String, List<DictAttrConfVo>> cache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DictAttrConfVoServiceImpl() {
        if (cache != null) return;
        Class<DictAttrConfVoServiceImpl> clazz = DictAttrConfVoServiceImpl.class;
        synchronized (DictAttrConfVoServiceImpl.class) {
            while (cache == null) {
                cache = CacheBuilder.newBuilder().initialCapacity(10000).expireAfterWrite(500L, TimeUnit.MILLISECONDS).maximumSize(100000L).build();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public List<DictAttrConfVo> findByDictTypeCode(String dictTypeCode) {
        if (StringUtils.isBlank((CharSequence)dictTypeCode)) {
            return new ArrayList<DictAttrConfVo>();
        }
        String cacheKey = StringUtils.join((Object[])new String[]{TenantUtils.getTenantCode(), dictTypeCode});
        List graph = (List)cache.getIfPresent((Object)cacheKey);
        if (graph != null) {
            return graph;
        }
        List<DictAttrConfEntity> list = this.dictAttrConfRepository.findByDictAttrConfCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DictAttrConfVo>();
        }
        graph = (List)this.nebulaToolkitService.copyCollectionByWhiteList(list, DictAttrConfEntity.class, DictAttrConfVo.class, HashSet.class, ArrayList.class, new String[0]);
        cache.put((Object)cacheKey, (Object)graph);
        return graph;
    }

    public DictAttrConfVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DictAttrConfEntity entity = (DictAttrConfEntity)((Object)this.dictAttrConfRepository.getById((Serializable)((Object)id)));
        if (entity == null) {
            // empty if block
        }
        return (DictAttrConfVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictAttrConfVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void save(DictAttrConfDto dto) {
        this.verify(dto);
        dto.setId(null);
        HashSet extFieldList = new HashSet(16);
        List<DictAttrConfEntity> list = this.dictAttrConfRepository.findByDictAttrConfCode(TenantUtils.getTenantCode(), dto.getDictTypeCode());
        if (CollectionUtils.isNotEmpty(list)) {
            extFieldList.addAll(list.stream().map(DictAttrConfEntity::getExtField).collect(Collectors.toSet()));
        }
        String extField = "";
        List<String> defaultExtFieldList = Arrays.asList("ext1", "ext2", "ext3", "ext4", "ext5", "ext6", "ext7", "ext8", "ext9", "ext10");
        for (String item : defaultExtFieldList) {
            if (extFieldList.contains(item)) continue;
            extField = item;
            break;
        }
        Validate.notBlank((CharSequence)extField, (String)"\u6269\u5c55\u5b57\u6bb5\u8303\u56f4\uff08ext1 ~ ext10\uff09", (Object[])new Object[0]);
        DictAttrConfEntity entity = (DictAttrConfEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictAttrConfEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setExtField(extField);
        this.dictDataVoService.deleteExtFieldVal(entity.getDictTypeCode(), Collections.singletonList(extField));
        entity.setTenantCode(TenantUtils.getTenantCode());
        entity.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        entity.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
        this.dictAttrConfRepository.save((Object)entity);
    }

    @Transactional
    public void update(DictAttrConfDto dto) {
        this.verify(dto);
        Validate.notBlank((CharSequence)dto.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictAttrConfEntity oldEntity = (DictAttrConfEntity)((Object)this.dictAttrConfRepository.getById((Serializable)((Object)dto.getId())));
        Validate.notNull((Object)((Object)oldEntity), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getExtField(), (String)"\u5360\u7528\u6570\u636e\u8868\u7684\u6269\u5c55\u5b57\u6bb5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.isTrue((boolean)oldEntity.getExtField().equals(dto.getExtField()), (String)"\u5360\u7528\u6570\u636e\u8868\u7684\u6269\u5c55\u5b57\u6bb5\u4e0d\u80fd\u4fee\u6539", (Object[])new Object[0]);
        if (dto.getSelectDictTypeCode() != null && !dto.getSelectDictTypeCode().equals(oldEntity.getSelectDictTypeCode()) || oldEntity.getSelectDictTypeCode() != null && !oldEntity.getSelectDictTypeCode().equals(dto.getSelectDictTypeCode())) {
            this.dictDataVoService.deleteExtFieldVal(oldEntity.getDictTypeCode(), Collections.singletonList(oldEntity.getExtField()));
        }
        DictAttrConfEntity entity = (DictAttrConfEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dto, DictAttrConfEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.dictAttrConfRepository.updateById((Object)entity);
        if (CollectionUtils.isNotEmpty(this.dictAttrConfEventListeners)) {
            DictAttrConfVo oldVo = (DictAttrConfVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)oldEntity, DictAttrConfVo.class, HashSet.class, ArrayList.class, new String[0]);
            DictAttrConfVo newVo = (DictAttrConfVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictAttrConfVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictAttrConfEventListeners.forEach(event -> event.onChange(oldVo, newVo));
        }
    }

    @Transactional
    public void deleteBatch(List<String> ids) {
        Validate.notEmpty(ids, (String)"\u7f3a\u5931\u53c2\u6570", (Object[])new Object[0]);
        List entities = ((DictAttrConfMapper)this.dictAttrConfRepository.getBaseMapper()).selectBatchIds(ids);
        Validate.isTrue((boolean)CollectionUtils.isNotEmpty((Collection)entities), (String)"\u5df2\u5220\u9664\u6216\u4e0d\u5b58\u5728", (Object[])new Object[0]);
        Map<String, List<DictAttrConfEntity>> map = entities.stream().collect(Collectors.groupingBy(DictAttrConfEntity::getDictTypeCode));
        for (Map.Entry<String, List<DictAttrConfEntity>> entry : map.entrySet()) {
            List extFieldList = entry.getValue().stream().map(DictAttrConfEntity::getExtField).collect(Collectors.toList());
            this.dictDataVoService.deleteExtFieldVal(entry.getKey(), extFieldList);
        }
        this.dictAttrConfRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.dictAttrConfEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)entities, DictAttrConfEntity.class, DictAttrConfVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictAttrConfEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    @Transactional
    public void deleteByDictTypeCode(String dictTypeCode) {
        Validate.notBlank((CharSequence)dictTypeCode, (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        List<DictAttrConfEntity> entities = this.dictAttrConfRepository.findByDictAttrConfCode(TenantUtils.getTenantCode(), dictTypeCode);
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        Set<String> ids = entities.stream().map(UuidEntity::getId).collect(Collectors.toSet());
        this.dictAttrConfRepository.updateDelFlagByIdIn(DelFlagStatusEnum.DELETE, ids);
        if (CollectionUtils.isNotEmpty(this.dictAttrConfEventListeners)) {
            List voList = (List)this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictAttrConfEntity.class, DictAttrConfVo.class, HashSet.class, ArrayList.class, new String[0]);
            this.dictAttrConfEventListeners.forEach(event -> event.onDelete(voList));
        }
    }

    private void verify(DictAttrConfDto dto) {
        Validate.notNull((Object)dto, (String)"\u8bf7\u6c42\u53c2\u6570\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getDictTypeCode(), (String)"\u7f3a\u5931\u6570\u636e\u5b57\u5178", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFieldCode(), (String)"\u5b57\u6bb5\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dto.getFieldName(), (String)"\u5b57\u6bb5\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getShowOrder(), (String)"\u663e\u793a\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)dto.getRequired(), (String)"\u662f\u5426\u5fc5\u586b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (StringUtils.isNotEmpty((CharSequence)dto.getSelectDictTypeCode())) {
            DictTypeEntity selectDict = this.dictTypeRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dto.getSelectDictTypeCode());
            Validate.notNull((Object)((Object)selectDict), (String)"\u4e0b\u62c9\u6846\u6570\u636e\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u65e0\u6548", (Object[])new Object[0]);
        }
        DictTypeEntity one = this.dictTypeRepository.findByDictTypeCode(TenantUtils.getTenantCode(), dto.getDictTypeCode());
        Validate.notNull((Object)((Object)one), (String)"\u672a\u627e\u5230\u5173\u8054\u6570\u636e\u5b57\u5178\u7c7b\u578b", (Object[])new Object[0]);
        List list = this.dictAttrConfRepository.findByDictAttrConfCode(TenantUtils.getTenantCode(), dto.getDictTypeCode()).stream().filter(x -> StringUtils.isEmpty((CharSequence)dto.getId()) || !dto.getId().equals(x.getId())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(list)) {
            Set fieldList = list.stream().map(DictAttrConfEntity::getFieldCode).collect(Collectors.toSet());
            Validate.isTrue((!fieldList.contains(dto.getFieldCode()) ? 1 : 0) != 0, (String)("\u5f53\u524d\u6570\u636e\u5b57\u5178\u4e0b\u5df2\u7ecf\u5b58\u5728\u8be5\u5b57\u6bb5\uff1a" + dto.getFieldCode()), (Object[])new Object[0]);
        }
    }
}

